/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.parser.PHPSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DocumentModelUtils {
    private static void resetDocumentReParser(@Nullable IStructuredDocument document, @Nullable IProject project) {
        if (document != null && document.getReParser() instanceof PHPSourceParser) {
            ((PHPSourceParser)document.getReParser()).setProject(project);
        }
    }

    public static void reparseAndReconcileDocument(@NonNull PHPStructuredTextViewer textViewer) {
        IDocument document = textViewer.getDocument();
        if (document instanceof IStructuredDocument) {
            DocumentModelUtils.reparseDocument(document);
        }
    }

    public static void reparseAndReconcileDocument(@NonNull PHPStructuredTextViewer textViewer, @Nullable IProject project) {
        IDocument document = textViewer.getDocument();
        if (document instanceof IStructuredDocument) {
            DocumentModelUtils.reparseDocument(document, project);
        }
    }

    public static void reparseDocument(@Nullable IDocument document) {
        IStructuredDocumentRegion[] sdRegions;
        if (!(document instanceof IStructuredDocument)) {
            return;
        }
        IStructuredDocument structuredDocument = (IStructuredDocument)document;
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdRegions = structuredDocument.getStructuredDocumentRegions();
        int n = sdRegions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion element = iStructuredDocumentRegionArray[n2];
            Iterator regionsIt = element.getRegions().iterator();
            DocumentModelUtils.reparseRegion(document, regionsIt, element.getStartOffset(), null, false);
            ++n2;
        }
    }

    public static void reparseDocument(@Nullable IDocument document, @Nullable IProject project) {
        IStructuredDocumentRegion[] sdRegions;
        if (!(document instanceof IStructuredDocument)) {
            return;
        }
        IStructuredDocument structuredDocument = (IStructuredDocument)document;
        DocumentModelUtils.resetDocumentReParser((IStructuredDocument)document, project);
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = sdRegions = structuredDocument.getStructuredDocumentRegions();
        int n = sdRegions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion element = iStructuredDocumentRegionArray[n2];
            Iterator regionsIt = element.getRegions().iterator();
            DocumentModelUtils.reparseRegion(document, regionsIt, element.getStartOffset(), project, true);
            ++n2;
        }
    }

    private static void reparseRegion(@NonNull IDocument document, @NonNull Iterator<?> regionsIt, int offset, @Nullable IProject project, boolean setNewProject) {
        while (regionsIt.hasNext()) {
            ITextRegion region = (ITextRegion)regionsIt.next();
            if (region instanceof ITextRegionContainer) {
                DocumentModelUtils.reparseRegion(document, ((ITextRegionContainer)region).getRegions().iterator(), offset + region.getStart(), project, setNewProject);
            }
            if (!(region instanceof IPHPScriptRegion)) continue;
            IPHPScriptRegion phpRegion = (IPHPScriptRegion)region;
            try {
                if (setNewProject) {
                    phpRegion.completeReparse(document, offset + region.getStart(), region.getLength(), project);
                    continue;
                }
                phpRegion.completeReparse(document, offset + region.getStart(), region.getLength());
            }
            catch (Error e) {
                PHPUiPlugin.log(e);
            }
        }
    }
}

