/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.ASTError;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PHPModuleDeclaration
extends ModuleDeclaration {
    private List<ASTError> errors;
    private boolean hasErrors;
    private List<VarComment> varComments;
    private List<PHPDocBlock> phpDocBlocks = new LinkedList<PHPDocBlock>();
    private List<Comment> commentList = new LinkedList<Comment>();

    public PHPModuleDeclaration(int start, int end, @NonNull List<ASTNode> statements, @NonNull List<ASTError> errors, @NonNull List<VarComment> varComments) {
        super(end - start, true);
        this.setStatements(statements);
        this.setStart(start);
        this.setEnd(end);
        this.errors = errors;
        this.varComments = varComments;
    }

    public void doRebuild() {
        List statements = this.getStatements();
        if (statements != null) {
            for (final ASTNode node : statements) {
                try {
                    node.traverse(new ASTVisitor(){
                        private Stack<ASTNode> parentStack = new Stack();

                        public boolean visit(MethodDeclaration s) throws Exception {
                            if (s != node && (this.parentStack.isEmpty() || !(this.parentStack.peek() instanceof TypeDeclaration))) {
                                PHPModuleDeclaration.this.getFunctionList().add(s);
                            }
                            return super.visit(s);
                        }

                        public boolean visit(TypeDeclaration s) throws Exception {
                            if (s instanceof NamespaceDeclaration && ((NamespaceDeclaration)s).isGlobal()) {
                                return super.visit(s);
                            }
                            this.parentStack.add((ASTNode)s);
                            PHPModuleDeclaration.this.getTypeList().add(s);
                            return super.visit(s);
                        }

                        public boolean endvisit(TypeDeclaration s) throws Exception {
                            if (s instanceof NamespaceDeclaration && ((NamespaceDeclaration)s).isGlobal()) {
                                return super.endvisit(s);
                            }
                            this.parentStack.pop();
                            return super.endvisit(s);
                        }
                    });
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                }
            }
        }
    }

    public void addStatement(Statement statement) {
        super.addStatement((ASTNode)statement);
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public List<ASTError> getErrors() {
        return this.errors;
    }

    public List<ASTError> getAllErrors() {
        ErrorSearcher searcher = new ErrorSearcher();
        try {
            this.traverse(searcher);
        }
        catch (Exception exception) {}
        List<ASTError> errorsList = searcher.getErrors();
        errorsList.addAll(this.getErrors());
        return errorsList;
    }

    public boolean hasErrors() {
        return this.hasErrors || !this.errors.isEmpty();
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public List<VarComment> getVarComments() {
        return this.varComments;
    }

    public List<PHPDocBlock> getPHPDocBlocks() {
        return this.phpDocBlocks;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    private class ErrorSearcher
    extends ASTVisitor {
        private List<ASTError> errors = new LinkedList<ASTError>();

        private ErrorSearcher() {
        }

        public boolean visit(ASTError error) throws Exception {
            this.errors.add(error);
            return false;
        }

        public boolean visit(Statement s) throws Exception {
            if (s.getKind() == 4) {
                return this.visit((ASTError)s);
            }
            return super.visit(s);
        }

        public List<ASTError> getErrors() {
            return this.errors;
        }
    }
}

