/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.modelrepair.internal.participants.StereotypesUtil;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ApplyProfileAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.CreateMarkersAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.DeleteAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IStereotypeOrphanGroup;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternComparison;
import org.eclipse.papyrus.uml.modelrepair.internal.uripattern.ProfileNamespaceURIPatternRegistry;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZombieStereotypesDescriptor {
    private static final Pattern AUTO_NSURI_PATTERN = Pattern.compile("^http://.*/([^/]+)/\\d+$");
    private final Profile nullProfile = UMLFactory.eINSTANCE.createProfile();
    private final Resource resource;
    private final Package root;
    private final LabelProviderService labelProviderService;
    private final Set<EPackage> appliedProfileDefinitions;
    private final Multimap<ProfileContext, EObject> zombies = ArrayListMultimap.create();
    private final Map<IAdaptable, IRepairAction> suggestedActions = Maps.newHashMap();
    private final Function<? super EPackage, Profile> dynamicProfileSupplier;
    private Map<IAdaptable, Map<IRepairAction.Kind, IRepairAction>> repairActions = Maps.newHashMap();
    private Map<EPackage, Profile> definitionToProfileMap = Maps.newHashMap();

    public ZombieStereotypesDescriptor(Resource resource, Package root, Set<EPackage> appliedProfileDefinitions, Function<? super EPackage, Profile> dynamicProfileSupplier, LabelProviderService labelProviderService) {
        this.resource = resource;
        this.root = root;
        this.appliedProfileDefinitions = ZombieStereotypesDescriptor.includingSubpackages(appliedProfileDefinitions);
        this.dynamicProfileSupplier = dynamicProfileSupplier;
        this.labelProviderService = labelProviderService;
    }

    private static Set<EPackage> includingSubpackages(Collection<? extends EPackage> profileDefinitions) {
        HashSet result = Sets.newHashSet();
        for (EPackage ePackage : profileDefinitions) {
            ZombieStereotypesDescriptor.collectPackages(ePackage, result);
        }
        return result;
    }

    private static void collectPackages(EPackage ePackage, Collection<? super EPackage> result) {
        if (result.add((EPackage)ePackage) && !ePackage.getESubpackages().isEmpty()) {
            for (EPackage next : ePackage.getESubpackages()) {
                ZombieStereotypesDescriptor.collectPackages(next, result);
            }
        }
    }

    public void analyze(EObject stereotypeApplication) {
        EPackage schema = this.getEPackage(stereotypeApplication);
        if (schema == null || !this.appliedProfileDefinitions.contains(schema) && this.couldBeProfileDefinition(schema, stereotypeApplication) || this.appliedProfileDefinitions.contains(schema) && UMLUtil.getBaseElement((EObject)stereotypeApplication) == null) {
            ProfileContext context = this.getProfileContext(stereotypeApplication, schema);
            boolean newContext = !this.zombies.containsKey((Object)context);
            this.zombies.put((Object)context, (Object)stereotypeApplication);
            if (newContext && schema != null) {
                IAdaptable schemaAdaptable = context.getSchemaAdaptable();
                if (!this.suggestedActions.containsKey(schemaAdaptable)) {
                    this.suggestedActions.put(schemaAdaptable, this.computeSuggestedAction(schemaAdaptable));
                } else {
                    ApplyProfileAction applyProfile = (ApplyProfileAction)this.getRepairAction(schemaAdaptable, IRepairAction.Kind.APPLY_LATEST_PROFILE_DEFINITION);
                    if (applyProfile != null) {
                        applyProfile.addPackage(context.getApplyingPackage());
                    }
                }
            }
        }
    }

    protected boolean couldBeProfileDefinition(EPackage schema, EObject stereotypeApplication) {
        boolean result;
        boolean bl = result = this.findProfile(schema) != null;
        if (!result) {
            result = StereotypesUtil.isUnrecognizedSchema(schema, stereotypeApplication);
        }
        return result;
    }

    public boolean hasZombies() {
        return !this.zombies.isEmpty();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Collection<? extends IAdaptable> getZombieSchemas() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.zombies.keySet(), (Function)new Function<ProfileContext, IAdaptable>(){

            public IAdaptable apply(ProfileContext input) {
                return input.getSchemaAdaptable();
            }
        }));
    }

    public int getZombieCount(IAdaptable schema) {
        int result = 0;
        for (Map.Entry next : Iterables.filter(this.zombies.asMap().entrySet(), this.matches(schema))) {
            result += ((Collection)next.getValue()).size();
        }
        return result;
    }

    private Predicate<Map.Entry<ProfileContext, ?>> matches(IAdaptable schema) {
        IStereotypeOrphanGroup orphans = (IStereotypeOrphanGroup)AdapterUtils.adapt((Object)schema, IStereotypeOrphanGroup.class, null);
        final boolean isOrphanGroup = orphans != null;
        final EPackage targetSchema = isOrphanGroup ? orphans.getSchema() : (EPackage)AdapterUtils.adapt((Object)schema, EPackage.class, null);
        return new Predicate<Map.Entry<ProfileContext, ?>>(){

            public boolean apply(Map.Entry<ProfileContext, ?> input) {
                ProfileContext context = input.getKey();
                return context.isOrphanGroup() == isOrphanGroup && ZombieStereotypesDescriptor.equal(context.getSchema(), targetSchema, (EObject)ZombieStereotypesDescriptor.this.root);
            }
        };
    }

    public Collection<? extends EObject> getZombies(IAdaptable schema) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry next : Iterables.filter(this.zombies.asMap().entrySet(), this.matches(schema))) {
            result.addAll((Iterable)next.getValue());
        }
        return result.build();
    }

    public boolean repair(IAdaptable schema, IRepairAction repairAction, DiagnosticChain diagnostics, IProgressMonitor monitor) {
        EPackage ePackage = (EPackage)AdapterUtils.adapt((Object)schema, EPackage.class).get();
        return !repairAction.isNull() && repairAction.repair(this.resource, ePackage, this.getZombies(schema), diagnostics, monitor);
    }

    protected EPackage getEPackage(EObject object) {
        EClass eclass = object.eClass();
        return eclass == null ? null : eclass.getEPackage();
    }

    protected IRepairAction computeSuggestedAction(IAdaptable schema) {
        IRepairAction result = this.getRepairAction(schema, IRepairAction.Kind.APPLY_LATEST_PROFILE_DEFINITION);
        if (result.isNull()) {
            IStereotypeOrphanGroup orphanGroup = (IStereotypeOrphanGroup)AdapterUtils.adapt((Object)schema, IStereotypeOrphanGroup.class, null);
            if (orphanGroup != null) {
                result = this.getRepairAction(schema, IRepairAction.Kind.DELETE);
            }
            if (result.isNull()) {
                result = this.getRepairAction(schema, IRepairAction.Kind.NO_OP);
            }
        }
        return result;
    }

    protected Map<IRepairAction.Kind, IRepairAction> computeFeasibleRepairActions(IAdaptable schema) {
        EnumMap result = Maps.newEnumMap(IRepairAction.Kind.class);
        result.put(IRepairAction.NO_OP.kind(), IRepairAction.NO_OP);
        result.put(DeleteAction.INSTANCE.kind(), DeleteAction.INSTANCE);
        result.put(CreateMarkersAction.INSTANCE.kind(), CreateMarkersAction.INSTANCE);
        IStereotypeOrphanGroup orphanGroup = (IStereotypeOrphanGroup)AdapterUtils.adapt((Object)schema, IStereotypeOrphanGroup.class, null);
        if (orphanGroup == null) {
            EPackage ePackage = (EPackage)AdapterUtils.adapt((Object)schema, EPackage.class, null);
            Set<Package> packages = this.getContextPackages(ePackage);
            Profile profile = this.findProfile(ePackage);
            ApplyProfileAction applyProfile = profile == null ? new ApplyProfileAction(this.resource, packages, ZombieStereotypesDescriptor.curry(ePackage, this.dynamicProfileSupplier)) : new ApplyProfileAction(this.resource, packages, profile, this.labelProviderService);
            result.put(applyProfile.kind(), applyProfile);
        }
        return result;
    }

    List<ProfileContext> getProfileContexts(final EPackage schema) {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.zombies.keySet(), (Predicate)new Predicate<ProfileContext>(){

            public boolean apply(ProfileContext input) {
                return ZombieStereotypesDescriptor.equal(input.schema, schema, (EObject)ZombieStereotypesDescriptor.this.root);
            }
        }));
    }

    Set<Package> getContextPackages(EPackage schema) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getProfileContexts(schema), (Function)new Function<ProfileContext, Package>(){

            public Package apply(ProfileContext input) {
                return input.getApplyingPackage();
            }
        }));
    }

    static <F, T> Supplier<T> curry(F input, Function<? super F, T> function) {
        return Suppliers.compose(function, (Supplier)Suppliers.ofInstance(input));
    }

    public IRepairAction getSuggestedRepairAction(IAdaptable schema) {
        return this.suggestedActions.get(schema);
    }

    public IRepairAction getRepairAction(IAdaptable schema, IRepairAction.Kind kind) {
        IRepairAction result;
        Map<IRepairAction.Kind, IRepairAction> available = this.repairActions.get(schema);
        if (available == null) {
            available = this.computeFeasibleRepairActions(schema);
            this.repairActions.put(schema, available);
        }
        if ((result = available.get((Object)kind)) == null) {
            result = IRepairAction.NULL;
        }
        return result;
    }

    public List<IRepairAction> getAvailableRepairActions(IAdaptable schema) {
        Map<IRepairAction.Kind, IRepairAction> actions = this.repairActions.get(schema);
        return actions == null ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter(actions.values(), IRepairAction.NOT_NULL));
    }

    protected Profile findProfile(EPackage definition) {
        Profile result = this.definitionToProfileMap.get(definition);
        if (result == null) {
            result = UMLUtil.getProfile((EPackage)definition, (EObject)this.root);
            if (result == null) {
                result = this.nullProfile;
            }
            this.definitionToProfileMap.put(definition, result);
        }
        return result == this.nullProfile ? null : result;
    }

    protected ProfileContext getProfileContext(EObject stereotypeApplication, EPackage schema) {
        ProfileContext result;
        if (schema == null) {
            result = new ProfileContext(this.root, schema);
        } else {
            Element base = ZombieStereotypesDescriptor.getBaseElement(stereotypeApplication);
            if (base == null) {
                result = new ProfileContext(schema);
            } else {
                result = null;
                Package pkg = null;
                Package successor = base.getNearestPackage();
                block0: while (successor != null) {
                    pkg = successor;
                    IProfileApplicationDelegate delegate = ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(pkg);
                    for (ProfileApplication next : delegate.getProfileApplications(pkg)) {
                        if (!ZombieStereotypesDescriptor.equal(next.getAppliedDefinition(), schema, (EObject)this.root)) continue;
                        result = new ProfileContext(schema, next);
                        break block0;
                    }
                    Package package_ = successor = pkg.getOwner() == null ? null : pkg.getOwner().getNearestPackage();
                }
                if (result == null) {
                    result = new ProfileContext(pkg == null ? this.root : pkg, schema);
                }
            }
        }
        return result;
    }

    static Element getBaseElement(EObject stereotypeApplication) {
        Element result = null;
        block0: for (EStructuralFeature next : stereotypeApplication.eClass().getEAllStructuralFeatures()) {
            if (next instanceof EReference && next.getName().startsWith("base_")) {
                Object value = stereotypeApplication.eGet(next);
                if (!(value instanceof Element)) continue;
                result = (Element)value;
                break;
            }
            if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)next)) continue;
            FeatureMap.Internal fmap = (FeatureMap.Internal)stereotypeApplication.eGet(next);
            int entryIndex = -1;
            for (FeatureMap.Entry entry : fmap) {
                ++entryIndex;
                EStructuralFeature feature = entry.getEStructuralFeature();
                if (!feature.getName().startsWith("base_")) continue;
                Object value = fmap.get(feature, true);
                if (value instanceof EList) {
                    value = ((EList)value).get(0);
                    if (feature instanceof EReference) {
                        value = fmap.resolveProxy(feature, entryIndex, 0, value);
                    }
                }
                if (value instanceof String) {
                    value = stereotypeApplication.eResource().getEObject((String)value);
                }
                if (!(value instanceof Element)) continue;
                result = (Element)value;
                break block0;
            }
        }
        return result;
    }

    static boolean equal(EPackage schema1, EPackage schema2, EObject context) {
        String schema2uri;
        String schema1uri;
        boolean result = false;
        boolean bl = result = schema1 == schema2;
        if (!result && schema1 != null && !(result = Objects.equal((Object)(schema1uri = schema1.getNsURI()), (Object)(schema2uri = schema2.getNsURI())))) {
            Matcher m;
            URI uri2;
            Optional<ProfileNamespaceURIPatternComparison> comparison = ProfileNamespaceURIPatternRegistry.INSTANCE.tryFindComparison(schema1uri, schema2uri);
            if (comparison.isPresent()) {
                return ((ProfileNamespaceURIPatternComparison)comparison.get()).isEqualVersionlessNamespaceURI();
            }
            URI uri1 = ZombieStereotypesDescriptor.guessURI(schema1);
            result = Objects.equal((Object)uri1, (Object)(uri2 = ZombieStereotypesDescriptor.guessURI(schema2)));
            if (!result && (m = AUTO_NSURI_PATTERN.matcher(uri1.toString())).matches()) {
                String normalized1 = uri1.toString().substring(0, m.start(1));
                m.reset(uri2.toString());
                if (m.matches()) {
                    String normalized2 = uri2.toString().substring(0, m.start(1));
                    result = normalized1.equals(normalized2);
                }
            }
        }
        return result;
    }

    static URI guessURI(EPackage schema) {
        Matcher m;
        URI result = schema.eIsProxy() ? EcoreUtil.getURI((EObject)schema) : (schema.eResource() != null ? ((m = AUTO_NSURI_PATTERN.matcher(schema.getNsURI())).matches() ? schema.eResource().getURI().appendFragment(m.group(1)) : EcoreUtil.getURI((EObject)schema)) : URI.createURI((String)schema.getNsURI()));
        return result;
    }

    private static final class EPackageAdapter
    implements IAdaptable {
        private final EPackage ePackage;

        EPackageAdapter(EPackage ePackage) {
            this.ePackage = ePackage;
        }

        public Object getAdapter(Class adapter) {
            return adapter == EPackage.class ? this.ePackage : null;
        }

        public boolean equals(Object obj) {
            return obj instanceof EPackageAdapter && ((EPackageAdapter)obj).ePackage == this.ePackage;
        }

        public int hashCode() {
            return this.ePackage.hashCode();
        }
    }

    static class ProfileContext
    implements IAdaptable {
        private final Package applyingPackage;
        private final EPackage schema;
        private int hash;

        ProfileContext(Package applyingPackage, EPackage schema) {
            this.applyingPackage = applyingPackage;
            this.schema = schema;
            this.init();
        }

        ProfileContext(EPackage schema, ProfileApplication profileApplication) {
            this(profileApplication.getApplyingPackage(), schema);
        }

        ProfileContext(EPackage schema) {
            this(null, schema);
        }

        private void init() {
            String schemaHash = this.schema == null ? null : this.schema.getNsURI();
            this.hash = Objects.hashCode((Object[])new Object[]{this.applyingPackage, schemaHash});
        }

        public Package getApplyingPackage() {
            return this.applyingPackage;
        }

        public EPackage getSchema() {
            return this.schema;
        }

        public IAdaptable getSchemaAdaptable() {
            return this.isOrphanGroup() ? this : new EPackageAdapter(this.getSchema());
        }

        public boolean isOrphanGroup() {
            return this.getApplyingPackage() == null;
        }

        public Object getAdapter(Class adapter) {
            Object result = null;
            if (adapter == EPackage.class) {
                result = this.getSchema();
            } else if (adapter == IStereotypeOrphanGroup.class && this.isOrphanGroup()) {
                result = new IStereotypeOrphanGroup(){

                    public EPackage getSchema() {
                        return ProfileContext.this.getSchema();
                    }
                };
            }
            return result;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof ProfileContext) {
                ProfileContext other = (ProfileContext)obj;
                boolean bl = result = other.applyingPackage == this.applyingPackage;
                if (result) {
                    result = ZombieStereotypesDescriptor.equal(other.schema, this.schema, (EObject)this.applyingPackage);
                }
            }
            return result;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

