/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.editor;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.editor.NattableReloadContextProvider;
import org.eclipse.papyrus.infra.nattable.common.helper.TableReconcileHelper;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableVersioningUtils;
import org.eclipse.papyrus.infra.nattable.common.utils.TableEditorInput;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractEMFNattableEditor
extends EditorPart
implements NavigationTarget,
IInternationalizationEditor {
    protected ServicesRegistry servicesRegistry;
    protected INattableModelManager tableManager;
    private PartNameSynchronizer synchronizer;
    private PreferenceStore workspacePreferenceStore;

    public AbstractEMFNattableEditor(ServicesRegistry servicesRegistry, Table rawModel) {
        this.servicesRegistry = servicesRegistry;
        this.tableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(rawModel, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.synchronizer = new PartNameSynchronizer(rawModel);
        this.workspacePreferenceStore = this.getWorkspaceViewerPreferenceStore();
        LabelInternationalizationUtils.managePartLabelSynchronizer((EObject)rawModel, (IInternationalizationEditor)this);
    }

    public PreferenceStore getWorkspaceViewerPreferenceStore() {
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TableEditorInput tableEditorInput = new TableEditorInput(this.tableManager.getTable(), this.getEditingDomain());
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(tableEditorInput);
        this.setPartName(LabelInternationalization.getInstance().getTableLabel(this.tableManager.getTable()));
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.getTable() != null && !TableVersioningUtils.isOfCurrentPapyrusVersion(this.getTable())) {
            try {
                new TableReconcileHelper(this.getEditingDomain()).reconcileTable(this.getTable());
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    public TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.tableManager.createNattable(parent, 0, this.getSite());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == INattableModelManager.class) {
            return this.tableManager;
        }
        if (adapter == IMatrixTableWidgetManager.class) {
            if (this.tableManager instanceof IMatrixTableWidgetManager) {
                return this.tableManager;
            }
            return null;
        }
        if (adapter == Table.class && this.tableManager != null) {
            return this.tableManager.getTable();
        }
        if (adapter == IReloadContextProvider.class) {
            return new NattableReloadContextProvider(this);
        }
        return super.getAdapter(adapter);
    }

    public void reloadNattableModelManager() {
        if (this.tableManager != null) {
            if (TableHelper.isTreeTable((INattableModelManager)this.tableManager)) {
                this.reloadTreeNattableModelManager();
            } else {
                Table rawModel = this.tableManager.getTable();
                NatTable nattable = (NatTable)this.tableManager.getAdapter(NatTable.class);
                Composite parent = nattable.getParent();
                this.tableManager.dispose();
                this.tableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(rawModel, (ISelectionExtractor)new EObjectSelectionExtractor());
                nattable = this.tableManager.createNattable(parent, 0, this.getSite());
                nattable.getParent().layout();
            }
        }
    }

    protected void reloadTreeNattableModelManager() {
        Table rawModel = this.tableManager.getTable();
        NatTable nattable = (NatTable)this.tableManager.getAdapter(NatTable.class);
        Composite sliderComposite = nattable.getParent();
        Composite greatParent = sliderComposite.getParent();
        this.tableManager.dispose();
        sliderComposite.dispose();
        this.tableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(rawModel, (ISelectionExtractor)new EObjectSelectionExtractor());
        nattable = this.tableManager.createNattable(greatParent, 0, this.getSite());
        greatParent.layout();
    }

    public void dispose() {
        this.saveLocalPreferenceStoreValues();
        this.tableManager.dispose();
        this.synchronizer.dispose();
        this.tableManager = null;
        this.servicesRegistry = null;
        this.synchronizer = null;
        super.dispose();
    }

    protected void saveLocalPreferenceStoreValues() {
        try {
            if (this.getWorkspaceViewerPreferenceStore() != null && this.getWorkspaceViewerPreferenceStore().needsSaving()) {
                this.getWorkspaceViewerPreferenceStore().save();
            }
        }
        catch (IOException ioe) {
            Activator.log.warn("Preferences can' be saved");
        }
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public boolean revealElement(Object element) {
        return this.revealElement(Collections.singleton(element));
    }

    public boolean revealElement(Collection<?> elements) {
        if (this.tableManager instanceof NavigationTarget) {
            return ((NavigationTarget)this.tableManager).revealElement(elements);
        }
        return false;
    }

    public Table getTable() {
        return this.tableManager.getTable();
    }

    public TransactionalEditingDomain getTableEditingDomain() {
        return TableEditingDomainUtils.getTableEditingDomain((Table)this.getTable());
    }

    public TransactionalEditingDomain getTableContextEditingDomain() {
        return TableEditingDomainUtils.getTableContextEditingDomain((Table)this.getTable());
    }

    public void modifyPartName(String name) {
        this.setPartName(name);
    }

    public void refreshEditorPart() {
    }

    public class PartNameSynchronizer {
        private Table papyrusTable;
        private final Adapter tableNameListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name()) {
                    AbstractEMFNattableEditor.this.setPartName(LabelInternationalization.getInstance().getTableLabel(PartNameSynchronizer.this.papyrusTable));
                }
            }
        };

        public PartNameSynchronizer(Table papyrusTable) {
            this.setTable(papyrusTable);
        }

        public void dispose() {
            this.papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            this.papyrusTable = null;
        }

        public void setTable(Table papyrusTable) {
            if (this.papyrusTable != null) {
                papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            }
            this.papyrusTable = papyrusTable;
            AbstractEMFNattableEditor.this.setPartName(LabelInternationalization.getInstance().getTableLabel(papyrusTable));
            papyrusTable.eAdapters().add((Object)this.tableNameListener);
        }
    }
}

