/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.predicates.PredicatesUtil;
import org.eclipse.oomph.resources.ProjectFactory;
import org.eclipse.oomph.resources.ProjectHandler;
import org.eclipse.oomph.resources.ResourcesPackage;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.util.OomphPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceLocatorImpl
extends ModelElementImpl
implements SourceLocator {
    protected static final String ROOT_FOLDER_EDEFAULT = null;
    protected String rootFolder = ROOT_FOLDER_EDEFAULT;
    protected EList<String> excludedPaths;
    protected EList<ProjectFactory> projectFactories;
    protected EList<Predicate> predicates;
    protected static final boolean LOCATE_NESTED_PROJECTS_EDEFAULT = false;
    protected boolean locateNestedProjects = false;

    protected SourceLocatorImpl() {
    }

    protected EClass eStaticClass() {
        return ResourcesPackage.Literals.SOURCE_LOCATOR;
    }

    @Override
    public String getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public void setRootFolder(String newRootFolder) {
        String oldRootFolder = this.rootFolder;
        this.rootFolder = newRootFolder;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldRootFolder, (Object)this.rootFolder));
        }
    }

    @Override
    public EList<String> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.excludedPaths;
    }

    @Override
    public EList<ProjectFactory> getProjectFactories() {
        if (this.projectFactories == null) {
            this.projectFactories = new EObjectContainmentEList(ProjectFactory.class, (InternalEObject)this, 3);
        }
        return this.projectFactories;
    }

    @Override
    public boolean isLocateNestedProjects() {
        return this.locateNestedProjects;
    }

    @Override
    public void setLocateNestedProjects(boolean newLocateNestedProjects) {
        boolean oldLocateNestedProjects = this.locateNestedProjects;
        this.locateNestedProjects = newLocateNestedProjects;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldLocateNestedProjects, this.locateNestedProjects));
        }
    }

    @Override
    public EList<Predicate> getPredicates() {
        if (this.predicates == null) {
            this.predicates = new EObjectContainmentEList(Predicate.class, (InternalEObject)this, 4);
        }
        return this.predicates;
    }

    @Override
    public boolean matches(IProject project) {
        return PredicatesUtil.matchesPredicates((IResource)project, this.predicates);
    }

    @Override
    public IProject loadProject(EList<ProjectFactory> defaultProjectFactories, BackendContainer backendContainer, IProgressMonitor monitor) {
        BackendContainer rootContainer = SourceLocatorImpl.getRootContainer(this);
        return SourceLocatorImpl.loadProject(this, defaultProjectFactories, rootContainer, backendContainer, monitor);
    }

    @Override
    public void handleProjects(EList<ProjectFactory> defaultProjectFactories, ProjectHandler projectHandler, MultiStatus status, IProgressMonitor monitor) {
        SourceLocatorImpl.handleProjects(this, defaultProjectFactories, projectHandler, status, monitor);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getProjectFactories()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getPredicates()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getRootFolder();
            }
            case 2: {
                return this.getExcludedPaths();
            }
            case 3: {
                return this.getProjectFactories();
            }
            case 4: {
                return this.getPredicates();
            }
            case 5: {
                return this.isLocateNestedProjects();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setRootFolder((String)newValue);
                return;
            }
            case 2: {
                this.getExcludedPaths().clear();
                this.getExcludedPaths().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getProjectFactories().clear();
                this.getProjectFactories().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getPredicates().clear();
                this.getPredicates().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLocateNestedProjects((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setRootFolder(ROOT_FOLDER_EDEFAULT);
                return;
            }
            case 2: {
                this.getExcludedPaths().clear();
                return;
            }
            case 3: {
                this.getProjectFactories().clear();
                return;
            }
            case 4: {
                this.getPredicates().clear();
                return;
            }
            case 5: {
                this.setLocateNestedProjects(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return ROOT_FOLDER_EDEFAULT == null ? this.rootFolder != null : !ROOT_FOLDER_EDEFAULT.equals(this.rootFolder);
            }
            case 2: {
                return this.excludedPaths != null && !this.excludedPaths.isEmpty();
            }
            case 3: {
                return this.projectFactories != null && !this.projectFactories.isEmpty();
            }
            case 4: {
                return this.predicates != null && !this.predicates.isEmpty();
            }
            case 5: {
                return this.locateNestedProjects;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.matches((IProject)arguments.get(0));
            }
            case 2: {
                return this.loadProject((EList<ProjectFactory>)((EList)arguments.get(0)), (BackendContainer)arguments.get(1), (IProgressMonitor)arguments.get(2));
            }
            case 3: {
                this.handleProjects((EList<ProjectFactory>)((EList)arguments.get(0)), (ProjectHandler)arguments.get(1), (MultiStatus)arguments.get(2), (IProgressMonitor)arguments.get(3));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (rootFolder: ");
        result.append(this.rootFolder);
        result.append(", excludedPaths: ");
        result.append(this.excludedPaths);
        result.append(", locateNestedProjects: ");
        result.append(this.locateNestedProjects);
        result.append(')');
        return result.toString();
    }

    public static void addStatus(MultiStatus status, OomphPlugin plugin, String file, Object object) {
        IStatus childStatus = plugin.getStatus(object);
        String message = String.valueOf(childStatus.getMessage()) + " (while processing " + file + ")";
        MultiStatus multiStatus = new MultiStatus(childStatus.getPlugin(), childStatus.getCode(), message, childStatus.getException());
        multiStatus.addAll(childStatus);
        status.add((IStatus)multiStatus);
    }

    public static BackendContainer getRootContainer(SourceLocator sourceLocator) {
        String rootFolder = sourceLocator.getRootFolder();
        BackendResource rootResource = BackendResource.get(rootFolder);
        if (rootResource instanceof BackendContainer) {
            return (BackendContainer)rootResource;
        }
        return null;
    }

    public static IProject loadProject(SourceLocator sourceLocator, EList<ProjectFactory> defaultProjectFactories, BackendContainer rootContainer, BackendContainer backendContainer, IProgressMonitor monitor) {
        try {
            EList<ProjectFactory> effectiveProjectFactories = sourceLocator.getProjectFactories();
            if (effectiveProjectFactories.isEmpty() && defaultProjectFactories != null) {
                effectiveProjectFactories = defaultProjectFactories;
            }
            for (ProjectFactory projectFactory : effectiveProjectFactories) {
                IProject project = projectFactory.createProject(rootContainer, backendContainer, monitor);
                if (project == null) continue;
                return project;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static void handleProjects(final SourceLocator sourceLocator, final EList<ProjectFactory> defaultProjectFactories, final ProjectHandler projectHandler, final MultiStatus status, IProgressMonitor monitor) {
        final BackendContainer rootContainer = SourceLocatorImpl.getRootContainer(sourceLocator);
        if (rootContainer == null) {
            monitor.setTaskName("Skipping root folder '" + sourceLocator.getRootFolder() + "' because it doesn't exist");
            return;
        }
        final HashSet<URI> excludedURIs = new HashSet<URI>();
        for (String path : sourceLocator.getExcludedPaths()) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            excludedURIs.add(URI.createURI((String)path));
        }
        rootContainer.accept(new BackendResource.Visitor.Default(){

            public boolean visitContainer(BackendContainer container, IProgressMonitor monitor) throws BackendException {
                ResourcesPlugin.checkCancelation((IProgressMonitor)monitor);
                if (this.isExcludedPath(rootContainer, container)) {
                    return false;
                }
                IProject project = SourceLocatorImpl.loadProject(sourceLocator, (EList<ProjectFactory>)defaultProjectFactories, rootContainer, container, monitor);
                if (PredicatesUtil.matchesPredicates((IResource)project, sourceLocator.getPredicates())) {
                    try {
                        projectHandler.handleProject(project, container);
                    }
                    catch (Exception ex) {
                        SourceLocatorImpl.addStatus(status, ResourcesPlugin.INSTANCE, project.getName(), ex);
                    }
                    if (!sourceLocator.isLocateNestedProjects()) {
                        return false;
                    }
                }
                return true;
            }

            private boolean isExcludedPath(BackendContainer rootContainer2, BackendContainer backendContainer) {
                URI relativeURI = backendContainer.getRelativeURI(rootContainer2);
                return relativeURI != null && excludedURIs.contains(relativeURI);
            }
        }, monitor);
    }
}

