/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.cse;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cse.AbstractPlace;
import org.eclipse.ocl.examples.codegen.cse.CommonSubexpressionEliminator;
import org.eclipse.ocl.examples.codegen.cse.GlobalPlace;
import org.eclipse.ocl.examples.codegen.cse.StackPlace;

public class OuterStackPlace
extends StackPlace {
    public static @Nullable OuterStackPlace createOuterStackPlace(@NonNull Map<@Nullable CGElement, @NonNull AbstractPlace> element2place, @NonNull CGElement cgStackElement) {
        GlobalPlace globalPlace = OuterStackPlace.getGlobalPlace(element2place);
        OuterStackPlace stackPlace = new OuterStackPlace(globalPlace, cgStackElement);
        return stackPlace;
    }

    protected OuterStackPlace(@NonNull GlobalPlace globalPlace, @NonNull CGElement stackElement) {
        super(globalPlace, stackElement);
        globalPlace.addStackPlace(this);
    }

    @Override
    public @NonNull GlobalPlace getParentPlace() {
        return this.globalPlace;
    }

    public void optimize() {
        this.pushUp();
        if (CommonSubexpressionEliminator.CSE_PUSH_UP.isActive()) {
            CommonSubexpressionEliminator.CSE_PUSH_UP.println("Places after push up");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_PUSH_UP, "");
        }
        this.pullUp();
        if (CommonSubexpressionEliminator.CSE_PULL_UP.isActive()) {
            CommonSubexpressionEliminator.CSE_PULL_UP.println("Places after pull up");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_PULL_UP, "");
        }
        this.prune();
        if (CommonSubexpressionEliminator.CSE_PRUNE.isActive()) {
            CommonSubexpressionEliminator.CSE_PRUNE.println("Places after prune");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_PRUNE, "");
        }
        this.rewrite();
        if (CommonSubexpressionEliminator.CSE_REWRITE.isActive()) {
            CommonSubexpressionEliminator.CSE_REWRITE.println("Places after rewrite");
            this.printHierarchy((Appendable)CommonSubexpressionEliminator.CSE_REWRITE, "");
        }
    }
}

