/*******************************************************************************
 * Copyright (c) 2009, 2011 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.ecore.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.ocl.ecore.util.EcoreAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EcoreItemProviderAdapterFactory
		extends EcoreAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EcoreItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.AnyType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnyTypeItemProvider anyTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.AnyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnyTypeAdapter() {
		if (anyTypeItemProvider == null) {
			anyTypeItemProvider = new AnyTypeItemProvider(this);
		}

		return anyTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.BagType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BagTypeItemProvider bagTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.BagType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBagTypeAdapter() {
		if (bagTypeItemProvider == null) {
			bagTypeItemProvider = new BagTypeItemProvider(this);
		}

		return bagTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.CollectionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionTypeItemProvider collectionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.CollectionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionTypeAdapter() {
		if (collectionTypeItemProvider == null) {
			collectionTypeItemProvider = new CollectionTypeItemProvider(this);
		}

		return collectionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.ElementType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementTypeItemProvider elementTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.ElementType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementTypeAdapter() {
		if (elementTypeItemProvider == null) {
			elementTypeItemProvider = new ElementTypeItemProvider(this);
		}

		return elementTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.InvalidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidTypeItemProvider invalidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.InvalidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvalidTypeAdapter() {
		if (invalidTypeItemProvider == null) {
			invalidTypeItemProvider = new InvalidTypeItemProvider(this);
		}

		return invalidTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.MessageType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageTypeItemProvider messageTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.MessageType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageTypeAdapter() {
		if (messageTypeItemProvider == null) {
			messageTypeItemProvider = new MessageTypeItemProvider(this);
		}

		return messageTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.OrderedSetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderedSetTypeItemProvider orderedSetTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.OrderedSetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderedSetTypeAdapter() {
		if (orderedSetTypeItemProvider == null) {
			orderedSetTypeItemProvider = new OrderedSetTypeItemProvider(this);
		}

		return orderedSetTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.PrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeItemProvider primitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.PrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeAdapter() {
		if (primitiveTypeItemProvider == null) {
			primitiveTypeItemProvider = new PrimitiveTypeItemProvider(this);
		}

		return primitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.SequenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceTypeItemProvider sequenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.SequenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceTypeAdapter() {
		if (sequenceTypeItemProvider == null) {
			sequenceTypeItemProvider = new SequenceTypeItemProvider(this);
		}

		return sequenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.SetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetTypeItemProvider setTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.SetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetTypeAdapter() {
		if (setTypeItemProvider == null) {
			setTypeItemProvider = new SetTypeItemProvider(this);
		}

		return setTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TemplateParameterType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterTypeItemProvider templateParameterTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TemplateParameterType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterTypeAdapter() {
		if (templateParameterTypeItemProvider == null) {
			templateParameterTypeItemProvider = new TemplateParameterTypeItemProvider(
				this);
		}

		return templateParameterTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TupleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleTypeItemProvider tupleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TupleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleTypeAdapter() {
		if (tupleTypeItemProvider == null) {
			tupleTypeItemProvider = new TupleTypeItemProvider(this);
		}

		return tupleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeTypeItemProvider typeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeTypeAdapter() {
		if (typeTypeItemProvider == null) {
			typeTypeItemProvider = new TypeTypeItemProvider(this);
		}

		return typeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.VoidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoidTypeItemProvider voidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.VoidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVoidTypeAdapter() {
		if (voidTypeItemProvider == null) {
			voidTypeItemProvider = new VoidTypeItemProvider(this);
		}

		return voidTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.CallOperationAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallOperationActionItemProvider callOperationActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.CallOperationAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallOperationActionAdapter() {
		if (callOperationActionItemProvider == null) {
			callOperationActionItemProvider = new CallOperationActionItemProvider(
				this);
		}

		return callOperationActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.Constraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintItemProvider constraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.Constraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstraintAdapter() {
		if (constraintItemProvider == null) {
			constraintItemProvider = new ConstraintItemProvider(this);
		}

		return constraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.SendSignalAction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendSignalActionItemProvider sendSignalActionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.SendSignalAction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendSignalActionAdapter() {
		if (sendSignalActionItemProvider == null) {
			sendSignalActionItemProvider = new SendSignalActionItemProvider(
				this);
		}

		return sendSignalActionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.ExpressionInOCL} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionInOCLItemProvider expressionInOCLItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.ExpressionInOCL}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionInOCLAdapter() {
		if (expressionInOCLItemProvider == null) {
			expressionInOCLItemProvider = new ExpressionInOCLItemProvider(this);
		}

		return expressionInOCLItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.AssociationClassCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssociationClassCallExpItemProvider associationClassCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.AssociationClassCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssociationClassCallExpAdapter() {
		if (associationClassCallExpItemProvider == null) {
			associationClassCallExpItemProvider = new AssociationClassCallExpItemProvider(
				this);
		}

		return associationClassCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.BooleanLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanLiteralExpItemProvider booleanLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.BooleanLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanLiteralExpAdapter() {
		if (booleanLiteralExpItemProvider == null) {
			booleanLiteralExpItemProvider = new BooleanLiteralExpItemProvider(
				this);
		}

		return booleanLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.CollectionItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionItemItemProvider collectionItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.CollectionItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionItemAdapter() {
		if (collectionItemItemProvider == null) {
			collectionItemItemProvider = new CollectionItemItemProvider(this);
		}

		return collectionItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.CollectionLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionLiteralExpItemProvider collectionLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.CollectionLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionLiteralExpAdapter() {
		if (collectionLiteralExpItemProvider == null) {
			collectionLiteralExpItemProvider = new CollectionLiteralExpItemProvider(
				this);
		}

		return collectionLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.CollectionRange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionRangeItemProvider collectionRangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.CollectionRange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionRangeAdapter() {
		if (collectionRangeItemProvider == null) {
			collectionRangeItemProvider = new CollectionRangeItemProvider(this);
		}

		return collectionRangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.EnumLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumLiteralExpItemProvider enumLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.EnumLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumLiteralExpAdapter() {
		if (enumLiteralExpItemProvider == null) {
			enumLiteralExpItemProvider = new EnumLiteralExpItemProvider(this);
		}

		return enumLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.IfExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfExpItemProvider ifExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.IfExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfExpAdapter() {
		if (ifExpItemProvider == null) {
			ifExpItemProvider = new IfExpItemProvider(this);
		}

		return ifExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.IntegerLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerLiteralExpItemProvider integerLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.IntegerLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerLiteralExpAdapter() {
		if (integerLiteralExpItemProvider == null) {
			integerLiteralExpItemProvider = new IntegerLiteralExpItemProvider(
				this);
		}

		return integerLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.UnlimitedNaturalLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnlimitedNaturalLiteralExpItemProvider unlimitedNaturalLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.UnlimitedNaturalLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnlimitedNaturalLiteralExpAdapter() {
		if (unlimitedNaturalLiteralExpItemProvider == null) {
			unlimitedNaturalLiteralExpItemProvider = new UnlimitedNaturalLiteralExpItemProvider(
				this);
		}

		return unlimitedNaturalLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.InvalidLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidLiteralExpItemProvider invalidLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.InvalidLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvalidLiteralExpAdapter() {
		if (invalidLiteralExpItemProvider == null) {
			invalidLiteralExpItemProvider = new InvalidLiteralExpItemProvider(
				this);
		}

		return invalidLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.IterateExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IterateExpItemProvider iterateExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.IterateExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIterateExpAdapter() {
		if (iterateExpItemProvider == null) {
			iterateExpItemProvider = new IterateExpItemProvider(this);
		}

		return iterateExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.IteratorExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IteratorExpItemProvider iteratorExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.IteratorExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIteratorExpAdapter() {
		if (iteratorExpItemProvider == null) {
			iteratorExpItemProvider = new IteratorExpItemProvider(this);
		}

		return iteratorExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.LetExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LetExpItemProvider letExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.LetExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLetExpAdapter() {
		if (letExpItemProvider == null) {
			letExpItemProvider = new LetExpItemProvider(this);
		}

		return letExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.MessageExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageExpItemProvider messageExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.MessageExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageExpAdapter() {
		if (messageExpItemProvider == null) {
			messageExpItemProvider = new MessageExpItemProvider(this);
		}

		return messageExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.NullLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullLiteralExpItemProvider nullLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.NullLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullLiteralExpAdapter() {
		if (nullLiteralExpItemProvider == null) {
			nullLiteralExpItemProvider = new NullLiteralExpItemProvider(this);
		}

		return nullLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.OperationCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationCallExpItemProvider operationCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.OperationCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationCallExpAdapter() {
		if (operationCallExpItemProvider == null) {
			operationCallExpItemProvider = new OperationCallExpItemProvider(
				this);
		}

		return operationCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.PropertyCallExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyCallExpItemProvider propertyCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.PropertyCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyCallExpAdapter() {
		if (propertyCallExpItemProvider == null) {
			propertyCallExpItemProvider = new PropertyCallExpItemProvider(this);
		}

		return propertyCallExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.RealLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RealLiteralExpItemProvider realLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.RealLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRealLiteralExpAdapter() {
		if (realLiteralExpItemProvider == null) {
			realLiteralExpItemProvider = new RealLiteralExpItemProvider(this);
		}

		return realLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.StateExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateExpItemProvider stateExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.StateExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateExpAdapter() {
		if (stateExpItemProvider == null) {
			stateExpItemProvider = new StateExpItemProvider(this);
		}

		return stateExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.StringLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringLiteralExpItemProvider stringLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.StringLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringLiteralExpAdapter() {
		if (stringLiteralExpItemProvider == null) {
			stringLiteralExpItemProvider = new StringLiteralExpItemProvider(
				this);
		}

		return stringLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TupleLiteralExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleLiteralExpItemProvider tupleLiteralExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TupleLiteralExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleLiteralExpAdapter() {
		if (tupleLiteralExpItemProvider == null) {
			tupleLiteralExpItemProvider = new TupleLiteralExpItemProvider(this);
		}

		return tupleLiteralExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TupleLiteralPart} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleLiteralPartItemProvider tupleLiteralPartItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TupleLiteralPart}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleLiteralPartAdapter() {
		if (tupleLiteralPartItemProvider == null) {
			tupleLiteralPartItemProvider = new TupleLiteralPartItemProvider(
				this);
		}

		return tupleLiteralPartItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.TypeExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeExpItemProvider typeExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.TypeExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeExpAdapter() {
		if (typeExpItemProvider == null) {
			typeExpItemProvider = new TypeExpItemProvider(this);
		}

		return typeExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.UnspecifiedValueExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnspecifiedValueExpItemProvider unspecifiedValueExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.UnspecifiedValueExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnspecifiedValueExpAdapter() {
		if (unspecifiedValueExpItemProvider == null) {
			unspecifiedValueExpItemProvider = new UnspecifiedValueExpItemProvider(
				this);
		}

		return unspecifiedValueExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.Variable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableItemProvider variableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.Variable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAdapter() {
		if (variableItemProvider == null) {
			variableItemProvider = new VariableItemProvider(this);
		}

		return variableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.VariableExp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableExpItemProvider variableExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.VariableExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableExpAdapter() {
		if (variableExpItemProvider == null) {
			variableExpItemProvider = new VariableExpItemProvider(this);
		}

		return variableExpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.ecore.OppositePropertyCallExp} instances.
	 * <!-- begin-user-doc -->
	 * @since 3.1
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OppositePropertyCallExpItemProvider oppositePropertyCallExpItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.ecore.OppositePropertyCallExp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOppositePropertyCallExpAdapter() {
		if (oppositePropertyCallExpItemProvider == null) {
			oppositePropertyCallExpItemProvider = new OppositePropertyCallExpItemProvider(
				this);
		}

		return oppositePropertyCallExpItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null
			? this
			: parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
				|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (anyTypeItemProvider != null)
			anyTypeItemProvider.dispose();
		if (bagTypeItemProvider != null)
			bagTypeItemProvider.dispose();
		if (collectionTypeItemProvider != null)
			collectionTypeItemProvider.dispose();
		if (elementTypeItemProvider != null)
			elementTypeItemProvider.dispose();
		if (invalidTypeItemProvider != null)
			invalidTypeItemProvider.dispose();
		if (messageTypeItemProvider != null)
			messageTypeItemProvider.dispose();
		if (orderedSetTypeItemProvider != null)
			orderedSetTypeItemProvider.dispose();
		if (primitiveTypeItemProvider != null)
			primitiveTypeItemProvider.dispose();
		if (sequenceTypeItemProvider != null)
			sequenceTypeItemProvider.dispose();
		if (setTypeItemProvider != null)
			setTypeItemProvider.dispose();
		if (templateParameterTypeItemProvider != null)
			templateParameterTypeItemProvider.dispose();
		if (tupleTypeItemProvider != null)
			tupleTypeItemProvider.dispose();
		if (typeTypeItemProvider != null)
			typeTypeItemProvider.dispose();
		if (voidTypeItemProvider != null)
			voidTypeItemProvider.dispose();
		if (callOperationActionItemProvider != null)
			callOperationActionItemProvider.dispose();
		if (constraintItemProvider != null)
			constraintItemProvider.dispose();
		if (sendSignalActionItemProvider != null)
			sendSignalActionItemProvider.dispose();
		if (expressionInOCLItemProvider != null)
			expressionInOCLItemProvider.dispose();
		if (associationClassCallExpItemProvider != null)
			associationClassCallExpItemProvider.dispose();
		if (booleanLiteralExpItemProvider != null)
			booleanLiteralExpItemProvider.dispose();
		if (collectionItemItemProvider != null)
			collectionItemItemProvider.dispose();
		if (collectionLiteralExpItemProvider != null)
			collectionLiteralExpItemProvider.dispose();
		if (collectionRangeItemProvider != null)
			collectionRangeItemProvider.dispose();
		if (enumLiteralExpItemProvider != null)
			enumLiteralExpItemProvider.dispose();
		if (ifExpItemProvider != null)
			ifExpItemProvider.dispose();
		if (integerLiteralExpItemProvider != null)
			integerLiteralExpItemProvider.dispose();
		if (unlimitedNaturalLiteralExpItemProvider != null)
			unlimitedNaturalLiteralExpItemProvider.dispose();
		if (invalidLiteralExpItemProvider != null)
			invalidLiteralExpItemProvider.dispose();
		if (iterateExpItemProvider != null)
			iterateExpItemProvider.dispose();
		if (iteratorExpItemProvider != null)
			iteratorExpItemProvider.dispose();
		if (letExpItemProvider != null)
			letExpItemProvider.dispose();
		if (messageExpItemProvider != null)
			messageExpItemProvider.dispose();
		if (nullLiteralExpItemProvider != null)
			nullLiteralExpItemProvider.dispose();
		if (operationCallExpItemProvider != null)
			operationCallExpItemProvider.dispose();
		if (propertyCallExpItemProvider != null)
			propertyCallExpItemProvider.dispose();
		if (realLiteralExpItemProvider != null)
			realLiteralExpItemProvider.dispose();
		if (stateExpItemProvider != null)
			stateExpItemProvider.dispose();
		if (stringLiteralExpItemProvider != null)
			stringLiteralExpItemProvider.dispose();
		if (tupleLiteralExpItemProvider != null)
			tupleLiteralExpItemProvider.dispose();
		if (tupleLiteralPartItemProvider != null)
			tupleLiteralPartItemProvider.dispose();
		if (typeExpItemProvider != null)
			typeExpItemProvider.dispose();
		if (unspecifiedValueExpItemProvider != null)
			unspecifiedValueExpItemProvider.dispose();
		if (variableItemProvider != null)
			variableItemProvider.dispose();
		if (variableExpItemProvider != null)
			variableExpItemProvider.dispose();
		if (oppositePropertyCallExpItemProvider != null)
			oppositePropertyCallExpItemProvider.dispose();
	}

}
