/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class CheckoutPullRequestHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.checkoutPullRequest";

    private RevCommit getBase(Repository repo, PullRequest request) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walk = new RevWalk(repo);){
            return walk.parseCommit((AnyObjectId)repo.resolve(request.getBase().getSha()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final TaskData data = this.getTaskData(event);
        if (data == null) {
            return null;
        }
        Job job = new Job(MessageFormat.format(Messages.CheckoutPullRequestHandler_JobName, data.getTaskId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SubProgressMonitor sub;
                    PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
                    if (prComp == null) {
                        return Status.CANCEL_STATUS;
                    }
                    PullRequest request = prComp.getRequest();
                    Repository repo = PullRequestUtils.getRepository((PullRequest)request);
                    if (repo == null) {
                        return Status.CANCEL_STATUS;
                    }
                    String branchName = PullRequestUtils.getBranchName((PullRequest)request);
                    Ref branchRef = repo.getRef(branchName);
                    RemoteConfig remote = null;
                    String headBranch = null;
                    monitor.beginTask("", 5);
                    if (!PullRequestUtils.isFromSameRepository((PullRequest)request)) {
                        monitor.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskAddRemote, request.getHead().getRepo().getOwner().getLogin()));
                        remote = PullRequestUtils.addRemote((Repository)repo, (PullRequest)request);
                        headBranch = PullRequestUtils.getHeadBranch((PullRequest)request);
                    } else {
                        remote = PullRequestUtils.getRemoteConfig((Repository)repo, (String)"origin");
                        headBranch = request.getHead().getRef();
                    }
                    monitor.worked(1);
                    if (branchRef == null) {
                        sub = new SubProgressMonitor(monitor, 1);
                        sub.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskCreateBranch, branchName));
                        PullRequestUtils.configureTopicBranch((Repository)repo, (PullRequest)request);
                        new CreateLocalBranchOperation(repo, branchName, CheckoutPullRequestHandler.this.getBase(repo, request)).execute((IProgressMonitor)sub);
                        sub.done();
                    } else {
                        monitor.worked(1);
                    }
                    if (!PullRequestUtils.isCurrentBranch((String)branchName, (Repository)repo)) {
                        sub = new SubProgressMonitor(monitor, 1);
                        sub.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskCheckoutBranch, branchName));
                        BranchOperationUI.checkout((Repository)repo, (String)branchName).run((IProgressMonitor)sub);
                        sub.done();
                    } else {
                        monitor.worked(1);
                    }
                    sub = new SubProgressMonitor(monitor, 1);
                    sub.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskFetching, remote.getName()));
                    new FetchOperation(repo, remote, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"), false).run((IProgressMonitor)sub);
                    sub.done();
                    sub = new SubProgressMonitor(monitor, 1);
                    sub.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskMerging, headBranch));
                    new MergeOperation(repo, headBranch).execute((IProgressMonitor)sub);
                    sub.done();
                    monitor.done();
                    CheckoutPullRequestHandler.this.executeCallback(event);
                }
                catch (IOException e) {
                    GitHubUi.logError(e);
                }
                catch (CoreException e) {
                    GitHubUi.logError(e);
                }
                catch (URISyntaxException e) {
                    GitHubUi.logError(e);
                }
                catch (InvocationTargetException e) {
                    GitHubUi.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(job, event);
        return null;
    }
}

