/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

public abstract class Filter {
    public static final String[] FILTER_TYPES = new String[]{Messages.Filter_Label_Regex, Messages.Filter_Label_Numeric};
    protected FilterChangeListener listener;

    public abstract boolean setCriteria(String var1) throws IllegalArgumentException;

    public abstract String getCriteria();

    public abstract String getLabel();

    public abstract boolean isActive();

    abstract boolean acceptObject();

    abstract boolean accept(Object var1);

    abstract boolean accept(String var1);

    protected Filter(FilterChangeListener listener) {
        this.listener = listener;
    }

    static class Factory {
        public static Filter build(Column column, FilterChangeListener listener) {
            if (column.isNumeric()) {
                Format formatter = column.getFormatter();
                ValueConverter converter = (ValueConverter)column.getData(ValueConverter.class);
                boolean isPercentage = formatter instanceof DecimalFormat && ((DecimalFormat)formatter).toPattern().indexOf(37) >= 0;
                return isPercentage ? new PercentageFilter(listener, converter) : new NumericFilter(listener, converter);
            }
            return new PatternFilter(listener);
        }

        private Factory() {
        }
    }

    static interface FilterChangeListener {
        public void filterChanged(Filter var1);
    }

    private static class NumericFilter
    extends Filter {
        private static final String ERROR_MSG = Messages.Filter_Error_Parsing;
        String criteria;
        Test test;
        ValueConverter converter;

        public NumericFilter(FilterChangeListener listener, ValueConverter converter) {
            super(listener);
            this.converter = converter;
        }

        boolean acceptObject() {
            return true;
        }

        boolean accept(Object value) {
            double doubleValue;
            if (value == null) {
                return false;
            }
            double d = doubleValue = value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
            if (this.converter != null) {
                doubleValue = this.converter.convert(doubleValue);
            }
            return this.test.accept(doubleValue);
        }

        boolean accept(String value) {
            throw new UnsupportedOperationException();
        }

        public String getCriteria() {
            return this.criteria;
        }

        public boolean setCriteria(String criteria) throws IllegalArgumentException {
            if (criteria == null || criteria.trim().length() == 0) {
                boolean changed = this.criteria != null;
                this.criteria = null;
                this.test = null;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            if (this.criteria != null && this.criteria.equals(criteria)) {
                return false;
            }
            Test newTest = null;
            try {
                int indexOfDots = criteria.indexOf("..");
                if (indexOfDots >= 0) {
                    Double lowerBound = this.number(criteria.substring(0, indexOfDots).trim());
                    int lastIndexOfDots = criteria.lastIndexOf("..");
                    Double upperBound = this.number(criteria.substring(lastIndexOfDots + 2).trim());
                    if (lowerBound != null && upperBound != null) {
                        newTest = new CompositeTest(new LowerEqualBoundary(lowerBound), new UpperEqualBoundary(upperBound));
                    } else if (lowerBound != null) {
                        newTest = new LowerEqualBoundary(lowerBound);
                    } else if (upperBound != null) {
                        newTest = new UpperEqualBoundary(upperBound);
                    }
                } else {
                    newTest = criteria.charAt(0) == '>' ? (criteria.charAt(1) == '=' ? new LowerEqualBoundary(this.number(criteria.substring(2))) : new LowerBoundary(this.number(criteria.substring(1)))) : (criteria.charAt(0) == '<' ? (criteria.charAt(1) == '=' ? new UpperEqualBoundary(this.number(criteria.substring(2))) : new UpperBoundary(this.number(criteria.substring(1)))) : new EqualsTest(this.number(criteria)));
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.valueOf(ERROR_MSG) + e.getMessage(), e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.valueOf(ERROR_MSG) + e.getMessage(), e);
            }
            this.criteria = criteria;
            this.test = newTest;
            this.listener.filterChanged(this);
            return true;
        }

        protected Double number(String string) throws ParseException {
            if (string.length() == 0) {
                return null;
            }
            ParsePosition pos = new ParsePosition(0);
            NumberFormat f = DecimalFormat.getInstance();
            Number nresult = f.parse(string, pos);
            if (pos.getIndex() < string.length()) {
                throw new ParseException(MessageUtil.format(Messages.Filter_Error_IllegalCharacters, string.substring(pos.getIndex())), pos.getIndex());
            }
            Double result = nresult.doubleValue();
            return result;
        }

        public String getLabel() {
            return FILTER_TYPES[1];
        }

        public boolean isActive() {
            return this.criteria != null;
        }

        static class CompositeTest
        implements Test {
            Test a;
            Test b;

            private CompositeTest(Test a, Test b) {
                this.a = a;
                this.b = b;
            }

            public boolean accept(double value) {
                return this.a.accept(value) && this.b.accept(value);
            }
        }

        static class EqualsTest
        implements Test {
            double value;

            EqualsTest(double value) {
                this.value = value;
            }

            public boolean accept(double value) {
                return this.value == value;
            }
        }

        static class LowerBoundary
        implements Test {
            double bound;

            LowerBoundary(double bound) {
                this.bound = bound;
            }

            public boolean accept(double value) {
                return value > this.bound;
            }
        }

        static class LowerEqualBoundary
        implements Test {
            double bound;

            LowerEqualBoundary(double bound) {
                this.bound = bound;
            }

            public boolean accept(double value) {
                return value >= this.bound;
            }
        }

        static interface Test {
            public boolean accept(double var1);
        }

        static class UpperBoundary
        implements Test {
            double bound;

            UpperBoundary(double bound) {
                this.bound = bound;
            }

            public boolean accept(double value) {
                return value < this.bound;
            }
        }

        static class UpperEqualBoundary
        implements Test {
            double bound;

            UpperEqualBoundary(double bound) {
                this.bound = bound;
            }

            public boolean accept(double value) {
                return value <= this.bound;
            }
        }
    }

    private static class PatternFilter
    extends Filter {
        Pattern pattern;

        public PatternFilter(FilterChangeListener listener) {
            super(listener);
        }

        boolean acceptObject() {
            return false;
        }

        boolean accept(Object value) {
            throw new UnsupportedOperationException();
        }

        boolean accept(String value) {
            return value == null ? false : this.pattern.matcher(value).matches();
        }

        public boolean setCriteria(String criteria) throws IllegalArgumentException {
            if (criteria == null || criteria.trim().length() == 0) {
                boolean changed = this.pattern != null;
                this.pattern = null;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            try {
                Pattern p = Pattern.compile(PatternUtil.smartFix(criteria));
                boolean changed = this.pattern == null || !this.pattern.pattern().equals(p.pattern());
                this.pattern = p;
                if (changed) {
                    this.listener.filterChanged(this);
                }
                return changed;
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.valueOf(Messages.Filter_Error_InvalidRegex) + "\n\n" + e.getMessage(), e);
            }
        }

        public String getCriteria() {
            return this.pattern != null ? this.pattern.pattern() : null;
        }

        public String getLabel() {
            return FILTER_TYPES[0];
        }

        public boolean isActive() {
            return this.pattern != null;
        }
    }

    private static class PercentageFilter
    extends NumericFilter {
        public PercentageFilter(FilterChangeListener listener, ValueConverter converter) {
            super(listener, converter);
        }

        protected Double number(String string) throws ParseException {
            if (string.length() == 0) {
                return null;
            }
            if (string.charAt(string.length() - 1) == '%') {
                String substring = string.substring(0, string.length() - 1);
                return super.number(substring) / 100.0;
            }
            return super.number(string);
        }
    }

    public static interface ValueConverter {
        public double convert(double var1);
    }
}

