/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutePomAction
implements ILaunchShortcut,
IExecutableExtension {
    private static final Logger log = LoggerFactory.getLogger(ExecutePomAction.class);
    private boolean showDialog = false;
    private String goalName = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if ("WITH_DIALOG".equals(data)) {
            this.showDialog = true;
        } else {
            this.goalName = (String)data;
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            this.launch(((IFileEditorInput)editorInput).getFile().getParent(), mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object object = structuredSelection.getFirstElement();
            IContainer basedir = null;
            if (object instanceof IProject || object instanceof IFolder) {
                basedir = (IContainer)object;
            } else if (object instanceof IFile) {
                basedir = ((IFile)object).getParent();
            } else if (object instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)object;
                Object adapter = adaptable.getAdapter(IProject.class);
                if (adapter != null) {
                    basedir = (IContainer)adapter;
                } else {
                    adapter = adaptable.getAdapter(IFolder.class);
                    if (adapter != null) {
                        basedir = (IContainer)adapter;
                    } else {
                        adapter = adaptable.getAdapter(IFile.class);
                        if (adapter != null) {
                            basedir = ((IFile)object).getParent();
                        }
                    }
                }
            }
            this.launch(basedir, mode);
        }
    }

    private void launch(IContainer basecon, String mode) {
        if (basecon == null) {
            return;
        }
        IContainer basedir = this.findPomXmlBasedir(basecon);
        ILaunchConfiguration launchConfiguration = this.getLaunchConfiguration(basedir, mode);
        if (launchConfiguration == null) {
            return;
        }
        boolean openDialog = this.showDialog;
        if (!openDialog) {
            try {
                String goals = launchConfiguration.getAttribute("M2_GOALS", null);
                openDialog = goals == null || goals.trim().length() == 0;
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (openDialog) {
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)launchConfiguration, (String)mode);
            String groupId = group != null ? group.getIdentifier() : "org.eclipse.ui.externaltools.launchGroup";
            DebugUITools.openLaunchConfigurationDialog((Shell)this.getShell(), (ILaunchConfiguration)launchConfiguration, (String)groupId, null);
        } else {
            DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)mode);
        }
    }

    private Shell getShell() {
        return M2EUIPluginActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    /*
     * Exception decompiling
     */
    private IContainer findPomXmlBasedir(IContainer dir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ILaunchConfiguration createLaunchConfiguration(IContainer basedir, String goal) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
            String rawConfigName = NLS.bind((String)Messages.ExecutePomAction_executing, (Object)goal, (Object)basedir.getLocation().toString());
            String safeConfigName = launchManager.generateLaunchConfigurationName(rawConfigName);
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, safeConfigName);
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getLocation().toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${project}");
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
            this.setProjectConfiguration(workingCopy, basedir);
            IPath path = this.getJREContainerPath(basedir);
            if (path != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            return workingCopy;
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir) {
        ResolverConfiguration configuration;
        String selectedProfiles;
        IFile pomFile;
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade projectFacade = projectManager.create(pomFile = basedir.getFile((IPath)new Path("pom.xml")), false, (IProgressMonitor)new NullProgressMonitor());
        if (projectFacade != null && (selectedProfiles = (configuration = projectFacade.getResolverConfiguration()).getSelectedProfiles()) != null && selectedProfiles.length() > 0) {
            workingCopy.setAttribute("M2_PROFILES", selectedProfiles);
        }
    }

    private IPath getJREContainerPath(IContainer basedir) throws CoreException {
        IProject project = basedir.getProject();
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return entry.getPath();
                }
                ++i;
            }
        }
        return null;
    }

    private ILaunchConfiguration getLaunchConfiguration(IContainer basedir, String mode) {
        if (this.goalName != null) {
            return this.createLaunchConfiguration(basedir, this.goalName);
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        IPath basedirLocation = basedir.getLocation();
        if (!this.showDialog) {
            try {
                ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
                ArrayList<ILaunchConfiguration> matchingConfigs = new ArrayList<ILaunchConfiguration>();
                ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
                int n = launchConfigurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                    try {
                        Path workPath;
                        String workDir = LaunchingUtils.substituteVar(configuration.getAttribute(MavenLaunchConstants.ATTR_POM_DIR, null));
                        if (workDir != null && basedirLocation.equals((Object)(workPath = new Path(workDir)))) {
                            matchingConfigs.add(configuration);
                        }
                    }
                    catch (CoreException e) {
                        log.error("Skipping launch configuration {}", (Object)configuration.getName(), (Object)e);
                    }
                    ++n2;
                }
                if (matchingConfigs.size() == 1) {
                    log.info("Using existing launch configuration");
                    return (ILaunchConfiguration)matchingConfigs.get(0);
                }
                if (matchingConfigs.size() > 1) {
                    final IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), new ILabelProvider(){

                        public Image getImage(Object element) {
                            return labelProvider.getImage(element);
                        }

                        public String getText(Object element) {
                            if (element instanceof ILaunchConfiguration) {
                                ILaunchConfiguration configuration = (ILaunchConfiguration)element;
                                try {
                                    return String.valueOf(labelProvider.getText(element)) + " : " + configuration.getAttribute("M2_GOALS", "");
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            return labelProvider.getText(element);
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return labelProvider.isLabelProperty(element, property);
                        }

                        public void addListener(ILabelProviderListener listener) {
                            labelProvider.addListener(listener);
                        }

                        public void removeListener(ILabelProviderListener listener) {
                            labelProvider.removeListener(listener);
                        }

                        public void dispose() {
                            labelProvider.dispose();
                        }
                    });
                    dialog.setElements((Object[])matchingConfigs.toArray(new ILaunchConfiguration[matchingConfigs.size()]));
                    dialog.setTitle(Messages.ExecutePomAction_dialog_title);
                    if (mode.equals("debug")) {
                        dialog.setMessage(Messages.ExecutePomAction_dialog_debug_message);
                    } else {
                        dialog.setMessage(Messages.ExecutePomAction_dialog_run_message);
                    }
                    dialog.setMultipleSelection(false);
                    int result = dialog.open();
                    labelProvider.dispose();
                    return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        log.info("Creating new launch configuration");
        String newName = launchManager.generateLaunchConfigurationName(basedirLocation.lastSegment());
        try {
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, newName);
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, LaunchingUtils.generateProjectLocationVariableExpression(basedir.getProject()));
            this.setProjectConfiguration(workingCopy, basedir);
            return workingCopy.doSave();
        }
        catch (Exception ex) {
            log.error("Error creating new launch configuration", (Throwable)ex);
            return null;
        }
    }
}

