/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CNFOutlinePage
implements IContentOutlinePage {
    public static final String ID = "org.eclipse.lsp4e.outline";
    public static final String LINK_WITH_EDITOR_PREFERENCE = "org.eclipse.lsp4e.outline.linkWithEditor";
    private CommonViewer viewer;
    private IEclipsePreferences preferences;
    private LanguageServiceAccessor.LSPDocumentInfo info;
    private ITextEditor textEditor;
    private CaretListener selectByEditorCaretListener = new CaretListener(){

        public void caretMoved(CaretEvent event) {
            if (!CNFOutlinePage.this.preferences.getBoolean(CNFOutlinePage.LINK_WITH_EDITOR_PREFERENCE, true)) {
                return;
            }
            int offset = CNFOutlinePage.this.viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)CNFOutlinePage.this.viewer).widgetOffset2ModelOffset(event.caretOffset) : event.caretOffset;
            CNFOutlinePage.refreshTreeSelection((TreeViewer)CNFOutlinePage.this.viewer, offset, CNFOutlinePage.this.info.getDocument());
        }
    };

    public CNFOutlinePage(LanguageServiceAccessor.LSPDocumentInfo info, @Nullable ITextEditor textEditor) {
        this.preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        this.textEditor = textEditor;
        this.info = info;
    }

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer(ID, parent, 0);
        this.viewer.setInput((Object)this.info);
        if (this.textEditor != null) {
            StyledText styledText;
            this.viewer.addOpenListener(event -> {
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true)) {
                    this.textEditor.setFocus();
                }
            });
            if (this.textEditor instanceof AbstractTextEditor) {
                AbstractTextEditor editor = (AbstractTextEditor)this.textEditor;
                styledText = (StyledText)editor.getAdapter(Control.class);
            } else {
                styledText = null;
            }
            this.viewer.addSelectionChangedListener(event -> {
                Object selection;
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true) && this.viewer.getTree().isFocusControl() && this.viewer.getSelection() != null && (selection = ((TreeSelection)this.viewer.getSelection()).getFirstElement()) != null && selection instanceof SymbolInformation) {
                    Range range = ((SymbolInformation)selection).getLocation().getRange();
                    try {
                        int startLineOffest = this.info.getDocument().getLineOffset(range.getStart().getLine());
                        if (styledText != null) {
                            styledText.removeCaretListener(this.selectByEditorCaretListener);
                        }
                        this.textEditor.selectAndReveal(startLineOffest + range.getStart().getCharacter(), 0);
                        if (styledText != null) {
                            styledText.addCaretListener(this.selectByEditorCaretListener);
                        }
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                }
            });
            if (styledText != null) {
                styledText.addCaretListener(this.selectByEditorCaretListener);
            }
        }
    }

    public static void refreshTreeSelection(TreeViewer viewer, int offset, IDocument document) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Object[] objects = contentProvider.getElements(null);
        SymbolInformation bestSymbol = null;
        int level = 0;
        while (objects != null && objects.length > 0) {
            SymbolInformation nextChild = null;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolInformation symbol;
                Object object = objectArray[n2];
                SymbolInformation symbolInformation = symbol = object instanceof SymbolInformation ? (SymbolInformation)object : (SymbolInformation)Adapters.adapt((Object)object, SymbolInformation.class);
                if (symbol != null && CNFOutlinePage.isOffsetInSymbolRange(offset, symbol, document)) {
                    nextChild = symbol;
                    objects = contentProvider.getChildren((Object)symbol);
                    break;
                }
                ++n2;
            }
            if (nextChild == null) break;
            ++level;
            bestSymbol = nextChild;
        }
        if (bestSymbol != null) {
            int finalLevel = level;
            SymbolInformation finalBestSymbol = bestSymbol;
            Display.getDefault().asyncExec(() -> {
                viewer.expandToLevel(finalLevel);
                viewer.setSelection((ISelection)new StructuredSelection((Object)finalBestSymbol), true);
            });
        }
    }

    private static boolean isOffsetInSymbolRange(int offset, SymbolInformation symbol, IDocument document) {
        Range range = symbol.getLocation().getRange();
        try {
            int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            return startOffset <= offset && endOffset >= offset;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public void dispose() {
        this.viewer.dispose();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }
}

