/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.AbstractDataManipulator;
import org.eclipse.linuxtools.internal.perf.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SourceDisassemblyData
extends AbstractDataManipulator {
    public SourceDisassemblyData(String title, IPath workingDir, IProject project) {
        super(title, workingDir, project);
    }

    @Override
    public void parse() {
        URI workingDirURI = null;
        try {
            workingDirURI = new URI(this.getWorkDir().toOSString());
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        String[] cmd = this.getCommand(workingDirURI.getPath());
        this.performCommand(cmd, 1);
    }

    protected String[] getCommand(String workingDir) {
        return new String[]{"sh", "-c", "perf annotate -i " + workingDir + "perf.data" + " < /dev/null"};
    }
}

