/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.editor.ConfigurationPage;
import org.eclipse.libra.warproducts.ui.editor.OverviewPage;
import org.eclipse.libra.warproducts.ui.editor.WARProductExportAction;
import org.eclipse.libra.warproducts.ui.editor.WARProductInputContext;
import org.eclipse.libra.warproducts.ui.editor.WARProductInputContextManager;
import org.eclipse.libra.warproducts.ui.editor.WARProductOutlinePage;
import org.eclipse.libra.warproducts.ui.editor.WebXMLInputContext;
import org.eclipse.libra.warproducts.ui.editor.WebXMLSourcePage;
import org.eclipse.libra.warproducts.ui.validation.IValidationListener;
import org.eclipse.libra.warproducts.ui.validation.PluginStatusDialog;
import org.eclipse.libra.warproducts.ui.validation.WARProductValidateAction;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.product.ProductEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WARProductEditor
extends ProductEditor
implements IValidationListener {
    private static final String PRODUCT_EDITOR_IMAGE = "icons/exp_product.gif";
    private static final String WARPRODUCT_FILE_EXTENSION = ".warproduct";
    private WARProductExportAction exportAction;

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new OverviewPage((PDELauncherFormEditor)this));
            this.addPage((IFormPage)new ConfigurationPage((FormEditor)this, this.useFeatures()));
        }
        catch (PartInitException e) {
            PDEPlugin.logException((Throwable)e);
        }
        this.addSourcePage("web-context");
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        WebXMLSourcePage result = null;
        result = contextId.equals("web-context") ? new WebXMLSourcePage(editor, title, name) : super.createSourcePage(editor, title, name, contextId);
        return result;
    }

    public String getContextIDForSaveAs() {
        return "warproduct-context";
    }

    protected String getEditorID() {
        return "org.eclipse.libra.warproducts.WARProductEditor";
    }

    public void contributeToToolbar(IToolBarManager manager) {
        IProductModel model = (IProductModel)this.getAggregateModel();
        IProduct product = model.getProduct();
        WARProductValidateAction validationAction = new WARProductValidateAction((IWARProduct)product);
        validationAction.addValidationListener(this);
        manager.add((IAction)validationAction);
        manager.add((IAction)this.getExportAction());
    }

    private WARProductExportAction getExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new WARProductExportAction((PDEFormEditor)this);
            this.exportAction.setToolTipText(Messages.editorExport);
            String pluginId = "org.eclipse.libra.warproducts.ui";
            String imagePath = PRODUCT_EDITOR_IMAGE;
            ImageDescriptor descExportProductTool = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imagePath);
            this.exportAction.setImageDescriptor(descExportProductTool);
        }
        return this.exportAction;
    }

    protected InputContextManager createInputContextManager() {
        return new WARProductInputContextManager((PDEFormEditor)this);
    }

    protected void createSystemFileContexts(InputContextManager manager, FileStoreEditorInput input) {
        File file = new File(input.getURI());
        String name = file.getName();
        if (name.endsWith(WARPRODUCT_FILE_EXTENSION)) {
            try {
                IFileStore store = EFS.getStore((URI)file.toURI());
                FileStoreEditorInput in = new FileStoreEditorInput(store);
                manager.putContext((IEditorInput)in, (InputContext)new WARProductInputContext((PDEFormEditor)this, (IEditorInput)in, true));
            }
            catch (CoreException e) {
                PDEPlugin.logException((Throwable)e);
            }
        }
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input.getName().endsWith(WARPRODUCT_FILE_EXTENSION)) {
            WARProductInputContext context = new WARProductInputContext((PDEFormEditor)this, (IEditorInput)input, true);
            manager.putContext((IEditorInput)input, (InputContext)context);
        }
    }

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        WARProductInputContext context = new WARProductInputContext((PDEFormEditor)this, (IEditorInput)input, true);
        manager.putContext((IEditorInput)input, (InputContext)context);
        manager.monitorFile(input.getFile());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProductModel model = (IProductModel)this.getAggregateModel();
        IWARProduct product = (IWARProduct)model.getProduct();
        IFile webXml = root.getFile(product.getWebXml());
        FileEditorInput webXmlInput = new FileEditorInput(webXml);
        WebXMLInputContext webXmlContext = new WebXMLInputContext((PDEFormEditor)this, (IEditorInput)webXmlInput, false);
        manager.putContext((IEditorInput)webXmlInput, (InputContext)webXmlContext);
        manager.monitorFile(webXml);
    }

    public boolean useFeatures() {
        return false;
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new WARProductOutlinePage((PDEFormEditor)this);
    }

    public void validationFinished(Map errors) {
        Shell shell = PDEPlugin.getActiveWorkbenchShell();
        if (!errors.isEmpty()) {
            PluginStatusDialog dialog = new PluginStatusDialog(shell);
            dialog.setInput(errors);
            dialog.open();
        } else {
            String pluginValidationMessage = Messages.Validation;
            String noProblemsMessage = Messages.noProblems;
            MessageDialog.openInformation((Shell)shell, (String)pluginValidationMessage, (String)noProblemsMessage);
        }
    }

    protected String computeInitialPageId() {
        return "overview";
    }
}

