/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.preferences;

import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.ui.internal.grammar.GrammarContentProvider;
import org.eclipse.ldt.ui.internal.grammar.GrammarLabelProvider;
import org.eclipse.ldt.ui.internal.preferences.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LuaGrammarPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTreeViewer eeTreeViewer;

    protected String getHelpId() {
        return null;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.LuaGrammarPreferencePage_page_description);
        this.noDefaultAndApplyButton();
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, LuaLanguageToolkit.getDefault().getPreferenceQualifier()));
    }

    protected Control createContents(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(containerComposite);
        this.eeTreeViewer = new CheckboxTreeViewer(containerComposite, 2820);
        this.eeTreeViewer.setContentProvider((IContentProvider)new GrammarContentProvider());
        this.eeTreeViewer.setLabelProvider((IBaseLabelProvider)new GrammarLabelProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.eeTreeViewer.getControl());
        this.eeTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String grammar = (String)event.getElement();
                if (event.getChecked()) {
                    LuaGrammarPreferencePage.this.eeTreeViewer.setCheckedElements(new Object[]{grammar});
                    LuaGrammarPreferencePage.this.getPreferenceStore().setValue("Grammar__default_id", grammar);
                } else {
                    LuaGrammarPreferencePage.this.getPreferenceStore().setValue("Grammar__default_id", "none");
                }
                LuaGrammarPreferencePage.this.validateGrammar();
            }
        });
        this.initializePage();
        return containerComposite;
    }

    private void initializePage() {
        if (this.eeTreeViewer == null || this.eeTreeViewer.getControl().isDisposed()) {
            return;
        }
        List availableGrammars = LuaGrammarManager.getAvailableGrammars();
        this.eeTreeViewer.setInput((Object)availableGrammars);
        String defaultGrammar = this.getPreferenceStore().getString("Grammar__default_id");
        for (String grammar : availableGrammars) {
            this.eeTreeViewer.setChecked((Object)grammar, grammar.equals(defaultGrammar));
        }
    }

    public void validateGrammar() {
        if (this.eeTreeViewer.getCheckedElements().length == 0) {
            this.setMessage(Messages.LuaGrammarPreferencePage_Warning_no_grammar, 2);
            return;
        }
        this.setMessage(null);
    }
}

