/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.editor.text;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.ui.text.ScriptCommentScanner;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.dltk.ui.text.rules.CombinedWordRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.ldt.ui.internal.editor.LuaDocumentorTags;

public class LuaDocumentorScanner
extends ScriptCommentScanner {
    public LuaDocumentorScanner(ScriptSourceViewerConfiguration configuration) {
        super(configuration, "DLTK_doc", "DLTK_comment_task_tag", (ITodoTaskPreferences)new TodoTaskPreferencesOnPreferenceStore(configuration.getPreferenceStore()));
    }

    protected String[] getTokenProperties() {
        return new String[]{"DLTK_doc", "DLTK_comment_task_tag", "luadoc.tags"};
    }

    protected List<CombinedWordRule.WordMatcher> createMatchers() {
        List matchers = super.createMatchers();
        matchers.add(this.createLuaDocumentorKeywordMatcher());
        return matchers;
    }

    protected List<IRule> createRules() {
        return super.createRules();
    }

    private CombinedWordRule.WordMatcher createLuaDocumentorKeywordMatcher() {
        CombinedWordRule.WordMatcher matcher = new CombinedWordRule.WordMatcher();
        HashSet tags = new HashSet();
        Collections.addAll(tags, LuaDocumentorTags.getTags());
        for (String tag : tags) {
            matcher.addWord(tag, (IToken)this.getToken("luadoc.tags"));
        }
        return matcher;
    }

    protected int skipCommentChars() {
        int count = 0;
        int c = this.read();
        IWhitespaceDetector whitespaceDetector = new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return c == ' ' || c == '\t';
            }
        };
        while (whitespaceDetector.isWhitespace((char)c)) {
            ++count;
            c = this.read();
        }
        if (c == 45) {
            c = this.read();
            if (c == 45) {
                return 2 + count;
            }
            this.unread();
        }
        this.unread();
        return count;
    }

    protected IWordDetector createIdentifierDetector() {
        return new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '@' || Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return c == '.' || c == '-' || Character.isJavaIdentifierPart(c);
            }
        };
    }

    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            int i = 0;
            while (i < this.fRules.length) {
                IToken token = this.fRules[i].evaluate((ICharacterScanner)this);
                if (!token.isUndefined()) {
                    return token;
                }
                ++i;
            }
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }
}

