/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ActivateEditorForSpecTCAction {
    private ActivateEditorForSpecTCAction() {
    }

    public static void activateEditor(ISpecTestCasePO spec) {
        List<IEditorReference> editors = Plugin.getAllEditors();
        ArrayList<AbstractTestCaseEditor> hits = new ArrayList<AbstractTestCaseEditor>(editors.size());
        for (IEditorReference ref : editors) {
            IPersistentObject per;
            IEditorPart ed = ref.getEditor(true);
            if (!(ed instanceof AbstractTestCaseEditor) || !((per = ((AbstractTestCaseEditor)ed).getEditorHelper().getEditSupport().getWorkVersion()) instanceof INodePO)) continue;
            boolean include = false;
            Iterator it = ((INodePO)per).getAllNodeIter();
            while (it.hasNext()) {
                INodePO next = (INodePO)it.next();
                if (!(next instanceof IExecTestCasePO) || !spec.equals((Object)((IExecTestCasePO)next).getSpecTestCase())) continue;
                include = true;
                break;
            }
            if (!include) continue;
            hits.add((AbstractTestCaseEditor)ed);
        }
        if (hits.size() == 1) {
            ((AbstractTestCaseEditor)hits.get(0)).getSite().getPage().activate((IWorkbenchPart)hits.get(0));
            return;
        }
        if (hits.isEmpty()) {
            ActivateEditorForSpecTCAction.showReferrersDialog(spec);
            return;
        }
        ActivateEditorForSpecTCAction.showEditorsDialog(hits);
    }

    private static void showEditorsDialog(List<AbstractTestCaseEditor> editors) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Plugin.getActiveEditor().getSite().getShell(), (ILabelProvider)new GeneralLabelProvider());
        dialog.setTitle(Messages.ChooseEditorTitle);
        dialog.setElements(editors.toArray());
        dialog.setMessage(Messages.ChooseEditorFromList);
        dialog.open();
        if (dialog.getReturnCode() != 0 || !(dialog.getFirstResult() instanceof AbstractTestCaseEditor)) {
            return;
        }
        AbstractTestCaseEditor ed = (AbstractTestCaseEditor)dialog.getFirstResult();
        ed.getSite().getPage().activate((IWorkbenchPart)ed);
    }

    private static void showReferrersDialog(ISpecTestCasePO spec) {
        HashSet<INodePO> refs = new HashSet<INodePO>();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        Long projId = spec.getParentProjectId();
        ids.add(projId);
        for (IExecTestCasePO exec : NodePM.getExecTestCases((String)spec.getGuid(), ids)) {
            INodePO anc = exec.getSpecAncestor();
            if (anc == null || !anc.getParentProjectId().equals(projId)) continue;
            refs.add(anc);
        }
        if (refs.isEmpty()) {
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Plugin.getActiveEditor().getSite().getShell(), (ILabelProvider)new GeneralLabelProvider());
        dialog.setTitle(Messages.ChooseReferrerTitle);
        dialog.setElements(refs.toArray());
        dialog.setMessage(Messages.ChooseReferrerText);
        dialog.open();
        if (dialog.getReturnCode() != 0 || !(dialog.getFirstResult() instanceof INodePO)) {
            return;
        }
        AbstractOpenHandler.openEditor((IPersistentObject)((INodePO)dialog.getFirstResult()));
    }
}

