/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaElementReference;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.FileEditorInput;

public class OpenJpaResourceAction
extends BaseSelectionListenerAction {
    private JpaContextModel selectedNode;

    public OpenJpaResourceAction() {
        super(JptJpaUiMessages.OPEN_JPA_RESOURCE_ACTION_OPEN);
    }

    public boolean updateSelection(IStructuredSelection s) {
        this.selectedNode = null;
        return super.updateSelection(s) && this.updateSelection_(s);
    }

    private boolean updateSelection_(IStructuredSelection s) {
        if (s.size() == 1) {
            this.selectedNode = (JpaContextModel)s.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        if (this.isEnabled()) {
            this.run_();
        }
    }

    private void run_() {
        IResource resource = this.selectedNode.getResource();
        if (resource != null && resource.exists() && resource.getType() == 1) {
            this.openEditor((IFile)resource);
            if (this.selectedNode instanceof JpaStructureNode) {
                JpaSelectionManager selectionManager = (JpaSelectionManager)WorkbenchTools.getAdapter(JpaSelectionManager.class);
                selectionManager.setSelection((JpaStructureNode)this.selectedNode);
            }
        } else if (this.selectedNode instanceof JavaElementReference) {
            this.openJavaEditor(((JavaElementReference)this.selectedNode).getJavaElement());
        }
    }

    protected void openEditor(IFile file) {
        IEditorDescriptor editorDescriptor = WorkbenchTools.getDefaultEditor((IFile)file);
        if (editorDescriptor == null) {
            return;
        }
        IWorkbenchPage page = WorkbenchTools.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)JptJpaUiMessages.OPEN_JPA_RESOURCE_ACTION_ERROR, (String)ex.getMessage());
        }
    }

    private void openJavaEditor(IJavaElement element) {
        if (element != null) {
            try {
                JavaUI.openInEditor((IJavaElement)element, (boolean)true, (boolean)true);
            }
            catch (PartInitException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
            catch (JavaModelException e) {
                JptJpaUiPlugin.instance().logError(e);
            }
        }
    }
}

