/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientFactory;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientProxyUtil;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.RequestTemplate;
import org.eclipse.epp.internal.mpc.core.util.UserAgentUtil;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransport
implements ITransport {
    public static final String USER_AGENT;
    public static final String USER_AGENT_PROPERTY;
    public static final int DEFAULT_READ_TIMEOUT;
    public static final int DEFAULT_CONNECT_TIMEOUT;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    public static final String READ_TIMEOUT_PROPERTY;
    public static final String CONNECT_TIMEOUT_PROPERTY;
    public static final String CONNECTION_REQUEST_TIMEOUT_PROPERTY;
    private final HttpClient client;
    private final Executor executor;

    static {
        USER_AGENT_PROPERTY = String.valueOf(HttpClientTransport.class.getPackage().getName()) + ".userAgent";
        DEFAULT_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        DEFAULT_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
        DEFAULT_CONNECTION_REQUEST_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        READ_TIMEOUT_PROPERTY = String.valueOf(HttpClientTransport.class.getPackage().getName()) + ".readTimeout";
        CONNECT_TIMEOUT_PROPERTY = String.valueOf(HttpClientTransport.class.getPackage().getName()) + ".connectTimeout";
        CONNECTION_REQUEST_TIMEOUT_PROPERTY = String.valueOf(HttpClientTransport.class.getPackage().getName()) + ".connectionRequestTimeout";
        USER_AGENT = UserAgentUtil.computeUserAgent();
    }

    public HttpClientTransport() {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        this.client = httpClientFactory.build();
        this.executor = httpClientFactory.getExecutor();
    }

    public HttpClient getClient() {
        return this.client;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected Response execute(Request request, URI uri) throws ClientProtocolException, IOException {
        return HttpClientProxyUtil.proxyAuthentication(this.executor, uri).execute(request);
    }

    protected Request configureRequest(Request request, URI uri) {
        return request.viaProxy(HttpClientProxyUtil.getProxyHost(uri));
    }

    @Override
    public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, ServiceUnavailableException, CoreException {
        try {
            return this.createStreamingRequest().execute(location);
        }
        catch (HttpResponseException e) {
            int statusCode = e.getStatusCode();
            switch (statusCode) {
                case 404: {
                    FileNotFoundException fnfe = new FileNotFoundException(e.getMessage());
                    fnfe.initCause(e);
                    throw fnfe;
                }
                case 503: {
                    throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
                }
            }
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
        catch (IOException e) {
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
    }

    protected RequestTemplate<InputStream> createStreamingRequest() {
        return new RequestTemplate<InputStream>(this){

            @Override
            protected Request createRequest(URI uri) {
                return Request.Get((URI)uri);
            }

            @Override
            protected InputStream handleResponse(Response response) throws ClientProtocolException, IOException {
                HttpResponse returnResponse = response.returnResponse();
                HttpEntity entity = returnResponse.getEntity();
                StatusLine statusLine = returnResponse.getStatusLine();
                this.handleResponseStatus(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                return (InputStream)this.handleResponseEntity(entity);
            }

            @Override
            protected InputStream handleResponseStream(InputStream content, Charset charset) throws IOException {
                return content;
            }

            @Override
            protected InputStream handleEmptyResponse() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }
}

