/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.emf.core.command.EmfCommandUtils;
import org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandFactoryUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandList;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetAndCustomCommandFactory {
    private final Table table;
    private final BasicCommandFactory basicCmdFactory;

    public FacetAndCustomCommandFactory(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.basicCmdFactory = basicCmdFactory;
    }

    public FacetAndCustomCommandFactory(Table table, ICommandFactory cmdFactory, EditingDomain editingDomain) {
        this.table = table;
        this.basicCmdFactory = new BasicCommandFactory(cmdFactory, editingDomain);
    }

    public Command createSetLoadedFacetSetsCommand(List<FacetSet> facetSets) {
        return this.createSetLoadedFacetSetsCommand(facetSets, true);
    }

    public Command createSetLoadedFacetSetsCommand(List<? extends FacetSet> facetSets, boolean manageCustoms) {
        CommandList commandList = new CommandList();
        List<FeatureColumn> columnsToRemove = CommandFactoryUtils.columnsToRemove(this.table, facetSets, (List<Row>)this.table.getRows());
        for (Column column : columnsToRemove) {
            Command removeColumnCmd = this.createRemoveColumnCommand(column);
            commandList.add(removeColumnCmd);
        }
        if (!this.table.getFacetSets().equals(facetSets)) {
            Command command = this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_FacetSets(), facetSets);
            commandList.add(command);
        }
        LinkedList<Customization> linkedList = new LinkedList<Customization>();
        for (FacetSet facetSet : facetSets) {
            if (!(facetSet instanceof Customization)) continue;
            Customization custom = (Customization)facetSet;
            linkedList.add(custom);
        }
        if (manageCustoms) {
            List<Customization> list = this.getRemovedCustoms(facetSets);
            if (!linkedList.isEmpty() || !list.isEmpty()) {
                ArrayList<Customization> customizations = new ArrayList<Customization>();
                customizations.addAll((Collection<Customization>)this.table.getCustomizations());
                customizations.removeAll(list);
                customizations.addAll(linkedList);
                Command loadCustom = this.createCoreSetCustomizationsCommand(customizations);
                commandList.add(loadCustom);
            }
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"Set loaded facetSets");
    }

    public Command createRemoveColumnCommand(Column column) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (this.table.getColumns().contains((Object)column)) {
            Command command = this.basicCmdFactory.createRemoveCommand(this.table, TablePackage.eINSTANCE.getTable_Columns(), column);
            commandList.add(command);
        }
        return EmfCommandUtils.createResult(commandList, (String)"Remove column");
    }

    public Command createSignatureFacetSetCommand(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        LinkedHashSet<FacetSet> newFacetSets = new LinkedHashSet<FacetSet>();
        newFacetSets.addAll(facetSets);
        newFacetSets.addAll((Collection<FacetSet>)this.table.getFacetSets());
        for (ETypedElement eTypedElement : eTypedElements) {
            FacetSet signatureFS = FacetAndCustomCommandFactory.getSignatureFacetSet(eTypedElement);
            if (signatureFS == null) continue;
            newFacetSets.add(signatureFS);
        }
        return this.createSetLoadedFacetSetsCommand(new ArrayList<FacetSet>(newFacetSets));
    }

    private static FacetSet getSignatureFacetSet(ETypedElement eTypedElement) {
        FacetSet result = null;
        if (eTypedElement instanceof DerivedTypedElement) {
            DerivedTypedElement signatureTE;
            DerivedTypedElement derivedTE = (DerivedTypedElement)eTypedElement;
            try {
                signatureTE = FacetUtils.getTopOverrideFeature((DerivedTypedElement)derivedTE);
            }
            catch (FacetManagerException e) {
                throw new TableWidgetRuntimeException(e);
            }
            if (derivedTE.getOverride() != null && signatureTE != null) {
                FacetSet signatureFS;
                result = signatureFS = FacetUtils.getFacetSet((ETypedElement)signatureTE);
            }
        }
        return result;
    }

    private List<Customization> getRemovedCustoms(List<? extends FacetSet> facetSets) {
        ArrayList removedFacetSet = new ArrayList();
        removedFacetSet.addAll(this.table.getFacetSets());
        removedFacetSet.removeAll(facetSets);
        LinkedList<Customization> removedCustoms = new LinkedList<Customization>();
        for (FacetSet facetSet : removedFacetSet) {
            if (!(facetSet instanceof Customization)) continue;
            Customization custom = (Customization)facetSet;
            removedCustoms.add(custom);
        }
        return removedCustoms;
    }

    public Command createSetCustomizationCommand(List<Customization> customizations) {
        CommandList commandList = new CommandList();
        Set<FacetSet> referredFS = CustomizationUtils.findFacetsCustomizedBy(customizations);
        EList alreadyLoaded = this.table.getFacetSets();
        ArrayList removedCustoms = new ArrayList();
        removedCustoms.addAll(this.table.getCustomizations());
        removedCustoms.removeAll(customizations);
        ArrayList<Object> facetSets = new ArrayList<Object>();
        facetSets.addAll(customizations);
        facetSets.removeAll((Collection<?>)alreadyLoaded);
        facetSets.addAll((Collection<Object>)alreadyLoaded);
        facetSets.removeAll(referredFS);
        facetSets.addAll(referredFS);
        facetSets.removeAll(removedCustoms);
        Command facetLoad = this.createSetLoadedFacetSetsCommand(facetSets, false);
        commandList.add(facetLoad);
        Command customLoad = this.createCoreSetCustomizationsCommand(customizations);
        commandList.add(customLoad);
        return EmfCommandUtils.createResult((List)commandList, (String)"Load cutomizations and associated facet sets");
    }

    public Command createCoreSetCustomizationsCommand(List<Customization> customizations) {
        ArrayList<Customization> sortedCustoms = new ArrayList<Customization>();
        sortedCustoms.addAll((Collection<Customization>)this.table.getLocalCustomizations());
        for (Customization customization : customizations) {
            if (sortedCustoms.contains(customization)) continue;
            sortedCustoms.add(customization);
        }
        CommandList commandList = new CommandList();
        if (!this.table.getCustomizations().equals(sortedCustoms)) {
            Command command = this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_Customizations(), sortedCustoms);
            commandList.add(command);
        }
        return EmfCommandUtils.createResult((List)commandList, (String)"Set loaded cutomizations");
    }
}

