/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.nattable.data.IDataProvider;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.exception.NatTableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider.GridElement;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.dataprovider.GridElementWithContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class BodyDataProvider
implements IDataProvider {
    private final int columnCount;
    private List<Row> elements;
    private final List<Column> columns;
    private final Shell shell;
    private final EditingDomain editingDomain;
    private final IFacetManager facetManager;
    private final ITableWidgetInternal controller;
    private final IGridElement[][] cache;
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());

    public BodyDataProvider(NatTableWidget natTableWidget) {
        this.controller = natTableWidget.getController();
        this.columns = this.controller.getTable().getColumns();
        this.shell = natTableWidget.getShell();
        this.editingDomain = this.controller.getEditingDomain();
        this.elements = new ArrayList<Row>((Collection<Row>)this.controller.getTable().getRows());
        this.columnCount = this.controller.getTable().getColumns().size();
        this.facetManager = this.controller.getFacetContext();
        this.cache = new IGridElement[this.columnCount][this.elements.size()];
    }

    public Row getRow(int row) {
        return this.elements.get(row);
    }

    public int getRowCount() {
        return this.elements.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        IGridElement result = this.cache[columnIndex][rowIndex];
        if (result == null && this.checkOutOfBounds(columnIndex)) {
            Column column = this.columns.get(columnIndex);
            Row row = this.elements.get(rowIndex);
            if (row instanceof NavigationRow) {
                NavigationRow tableElementWithContext = (NavigationRow)row;
                result = new GridElementWithContext(row, tableElementWithContext.getQueryResult().getSource(), column);
            } else {
                result = new GridElement(row, column, this.controller);
            }
            this.cache[columnIndex][rowIndex] = result;
            if (DEBUG) {
                String message = String.format("Caching IGridElement: columnIndex=%d, rowIndex=%d", columnIndex, rowIndex);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }

    private boolean checkOutOfBounds(int columnIndex) {
        boolean result;
        boolean bl = result = columnIndex >= this.columns.size();
        if (result) {
            String message = String.format("wrong column index: %d (%d columns)", columnIndex, this.columns.size());
            Logger.logError((String)message, (Plugin)Activator.getDefault());
        }
        return !result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Column column = this.columns.get(columnIndex);
        EObject element = this.elements.get(rowIndex).getElement();
        if (!(element instanceof EObject)) return;
        EObject eObject = element;
        if (!(column instanceof FeatureColumn)) {
            throw new NatTableWidgetRuntimeException("Cannot edit in column of type " + column.eClass().getName());
        }
        ETypedElement feature = ((FeatureColumn)column).getFeature();
        if (feature instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)feature;
            if (!structuralFeature.isChangeable()) {
                throw new NatTableWidgetRuntimeException("Feature is not changeable: " + feature.getName());
            }
            if (newValue == null && !structuralFeature.isUnsettable()) {
                MessageDialog.openWarning((Shell)this.shell, (String)Messages.BodyDataProvider_cannotUnset, (String)NLS.bind((String)Messages.BodyDataProvider_featureIsNotUnsettable, (Object)feature.getName()));
                return;
            }
        } else if (feature instanceof EOperation) {
            throw new NatTableWidgetRuntimeException("An operation can not be assigned");
        }
        Object prevValue = null;
        try {
            prevValue = this.facetManager.getOrInvoke(eObject, feature, Object.class);
        }
        catch (Exception e) {
            throw new NatTableWidgetRuntimeException(e);
        }
        if (prevValue == newValue) {
            return;
        }
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            Object object = eObject.eGet((EStructuralFeature)((EReference)feature));
            boolean empty = object == null || object instanceof List && ((List)object).isEmpty();
            String message = empty ? Messages.BodyDataProvider_valueWillBeMoved : Messages.BodyDataProvider_valueWillBeMovedAndPreviousLost;
            String fullMessage = String.valueOf(Messages.BodyDataProvider_featureIsComposite) + message;
            if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.BodyDataProvider_moveElement, (String)fullMessage)) {
                return;
            }
        }
        if (feature.eContainer() instanceof Facet) {
            try {
                if (!(feature instanceof EStructuralFeature)) return;
                EStructuralFeature structuralFeature = (EStructuralFeature)feature;
                this.facetManager.set(eObject, structuralFeature, newValue, this.editingDomain);
                return;
            }
            catch (Exception e) {
                throw new NatTableWidgetRuntimeException(e);
            }
        } else {
            ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
            Command setCommand = commandFactory.createSetCommand(this.editingDomain, (Object)eObject, (Object)feature, newValue);
            this.editingDomain.getCommandStack().execute(setCommand);
        }
    }
}

