/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.ui.tabs.HyperLinkDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

class HyperLinkPresenter
implements IHyperlinkPresenter,
IHyperlinkPresenterExtension2,
ITextPresentationListener,
ITextInputListener,
IDocumentListener,
IPropertyChangeListener {
    private ISourceViewer fSourceViewer;
    private GerritClient fGerritClient;
    private ChangeInfo fChangeInfo;
    private static final String HYPERLINK_COLOR = "hyperlinkColor";
    private static final String HYPERLINK_COLOR_SYSTEM_DEFAULT = "hyperlinkColor.SystemDefault";
    private ITextViewer fTextViewer;
    private Color fColor;
    private boolean fIsUsingNativeLinkColor;
    private RGB fRGB;
    private boolean fDisposeColor;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private IPreferenceStore fPreferenceStore;
    private int fClickedOffset;

    public HyperLinkPresenter(IPreferenceStore store) {
        this.fPreferenceStore = store;
        this.fDisposeColor = true;
    }

    public HyperLinkPresenter(Color color) {
        this.fColor = color;
    }

    HyperLinkPresenter(RGB rgb, ISourceViewer sourceViewer, GerritClient gerritClient, ChangeInfo changeInfo) {
        this.fRGB = rgb;
        this.fDisposeColor = true;
        this.fSourceViewer = sourceViewer;
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
    }

    public boolean canShowMultipleHyperlinks() {
        return true;
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        IHyperlink hyperlink;
        Assert.isLegal((hyperlinks != null && hyperlinks.length >= 1 ? 1 : 0) != 0);
        IHyperlink[] iHyperlinkArray = hyperlinks;
        int n = hyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            hyperlink = iHyperlinkArray[n2];
            this.highlightRegion(hyperlink.getHyperlinkRegion());
            ++n2;
        }
        if (hyperlinks != null && hyperlinks.length > 1) {
            iHyperlinkArray = hyperlinks;
            n = hyperlinks.length;
            n2 = 0;
            while (n2 < n) {
                hyperlink = iHyperlinkArray[n2];
                if (this.isWithinRegion(hyperlink.getHyperlinkRegion()) && this.fClickedOffset != -1) {
                    hyperlink.open();
                }
                ++n2;
            }
        }
        this.setOffset(-1);
    }

    public boolean canHideHyperlinks() {
        return true;
    }

    public void hideHyperlinks() {
        this.repairRepresentation();
        this.fRememberedPosition = null;
    }

    public void install(ITextViewer textViewer) {
        StyledText text;
        Assert.isNotNull((Object)textViewer);
        this.fTextViewer = textViewer;
        this.fTextViewer.addTextInputListener((ITextInputListener)this);
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)this.fTextViewer).addTextPresentationListener((ITextPresentationListener)this);
        }
        if (this.fPreferenceStore != null) {
            this.fIsUsingNativeLinkColor = this.fPreferenceStore.getBoolean(HYPERLINK_COLOR_SYSTEM_DEFAULT);
            if (!this.fIsUsingNativeLinkColor) {
                this.fColor = this.createColorFromPreferenceStore();
            }
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        } else if (this.fRGB != null && (text = this.fTextViewer.getTextWidget()) != null && !text.isDisposed()) {
            this.fColor = new Color((Device)text.getDisplay(), this.fRGB);
        }
    }

    public void uninstall() {
        this.fTextViewer.removeTextInputListener((ITextInputListener)this);
        IDocument document = this.fTextViewer.getDocument();
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fColor != null) {
            if (this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = null;
        }
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)this.fTextViewer).removeTextPresentationListener((ITextPresentationListener)this);
        }
        this.fTextViewer = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
    }

    public void setColor(Color color) {
        Assert.isNotNull((Object)this.fTextViewer);
        Assert.isTrue((this.fPreferenceStore == null ? 1 : 0) != 0, (String)"Cannot set color if preference store is set");
        if (this.fColor != null && this.fDisposeColor) {
            this.fColor.dispose();
        }
        this.fColor = color;
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        if (this.fActiveRegion == null) {
            return;
        }
        IRegion region = textPresentation.getExtent();
        if (this.fActiveRegion.getOffset() + this.fActiveRegion.getLength() >= region.getOffset() && region.getOffset() + region.getLength() > this.fActiveRegion.getOffset()) {
            Color color = null;
            if (!this.fIsUsingNativeLinkColor) {
                color = this.fColor;
            }
            StyleRange styleRange = new StyleRange(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength(), color, null);
            styleRange.underlineStyle = 4;
            styleRange.underline = true;
            textPresentation.mergeStyleRange(styleRange);
        }
    }

    private void highlightRegion(IRegion region) {
        if (region.equals(this.fActiveRegion)) {
            return;
        }
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        this.fActiveRegion = region;
        if (this.fTextViewer instanceof ITextViewerExtension6) {
            ((ITextViewerExtension2)this.fTextViewer).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    private void repairRepresentation() {
        if (this.fActiveRegion == null) {
            return;
        }
        int offset = this.fActiveRegion.getOffset();
        int length = this.fActiveRegion.getLength();
        this.fActiveRegion = null;
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)this.fTextViewer).invalidateTextPresentation(offset, length);
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.fActiveRegion != null) {
            this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
            try {
                event.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException x) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            } else {
                this.fActiveRegion = new Region(event.getOffset(), event.getLength());
            }
            this.fRememberedPosition = null;
            StyledText widget = this.fTextViewer.getTextWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HyperLinkPresenter.this.hideHyperlinks();
                    }
                });
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput == null) {
            return;
        }
        this.hideHyperlinks();
        oldInput.removeDocumentListener((IDocumentListener)this);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput == null) {
            return;
        }
        newInput.addDocumentListener((IDocumentListener)this);
        IHyperlink[] links = null;
        if (this.fSourceViewer != null) {
            links = new HyperLinkDetector(this.fGerritClient, this.fChangeInfo).detectHyperlinks((ITextViewer)this.fSourceViewer, null, true);
        }
        if (links != null) {
            this.showHyperlinks(links);
        }
    }

    private Color createColorFromPreferenceStore() {
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return null;
        }
        RGB rgb = null;
        if (this.fPreferenceStore.contains(HYPERLINK_COLOR) && (rgb = this.fPreferenceStore.isDefault(HYPERLINK_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)this.fPreferenceStore, (String)HYPERLINK_COLOR) : PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)HYPERLINK_COLOR)) != null) {
            return new Color((Device)textWidget.getDisplay(), rgb);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (HYPERLINK_COLOR.equals(event.getProperty())) {
            if (this.fColor != null && this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = this.createColorFromPreferenceStore();
            return;
        }
        if (HYPERLINK_COLOR_SYSTEM_DEFAULT.equals(event.getProperty())) {
            this.fIsUsingNativeLinkColor = this.fPreferenceStore.getBoolean(HYPERLINK_COLOR_SYSTEM_DEFAULT);
            if (!this.fIsUsingNativeLinkColor && this.fColor == null) {
                this.fColor = this.createColorFromPreferenceStore();
            }
            return;
        }
    }

    public void showHyperlinks(IHyperlink[] activeHyperlinks, boolean takesFocusWhenVisible) {
        if (activeHyperlinks != null && activeHyperlinks.length == 1) {
            return;
        }
        Assert.isLegal((activeHyperlinks != null && activeHyperlinks.length >= 1 ? 1 : 0) != 0);
        IHyperlink[] iHyperlinkArray = activeHyperlinks;
        int n = activeHyperlinks.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink hyperlink = iHyperlinkArray[n2];
            this.highlightRegion(hyperlink.getHyperlinkRegion());
            ++n2;
        }
    }

    private boolean isWithinRegion(IRegion region) {
        return this.fClickedOffset != -1 && this.fClickedOffset >= region.getOffset() && this.fClickedOffset <= region.getLength() + region.getOffset();
    }

    public void setOffset(int offset) {
        this.fClickedOffset = offset;
    }
}

