/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egerrit.internal.dashboard.ui.utils.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class UIUtils {
    private static final String EGERRIT_PREF = "org.eclipse.egerrit.prefs";
    private static final int TITLE_LENGTH = 75;

    private UIUtils() {
    }

    public static void showErrorDialog(String aMsg, String aReason) {
        ErrorDialog dialog = new ErrorDialog(null, Messages.UIUtils_dashboardInfo, aMsg, (IStatus)new Status(1, "org.eclipse.egerrit.dashboard.ui", 0, aReason, null), 1);
        Display.getDefault().syncExec(() -> {
            int n = dialog.open();
        });
    }

    public static void showNoServerMessage() {
        ErrorDialog dialog = new ErrorDialog(null, Messages.UIUtils_dashboardInfo, null, (IStatus)new Status(1, "org.eclipse.egerrit.dashboard.ui", Messages.UIUtils_configureMessage), 1);
        Display.getDefault().syncExec(() -> {
            int n = dialog.open();
        });
    }

    public static String quoteIfNeeded(String s) {
        if (!s.trim().matches("^\\S*$")) {
            if (s.endsWith(" ")) {
                return "\"" + s.trim() + "\" ";
            }
            return "\"" + s + "\"";
        }
        return s;
    }

    public static int showConfirmDialog(String key, Shell shell, String title, String value) {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(EGERRIT_PREF);
        Preferences editorPrefs = prefs.node(key);
        boolean choice = editorPrefs.getBoolean(key, false);
        if (choice) {
            return 256;
        }
        String adjustedTitle = title.length() > 75 ? title.substring(0, 72).concat("...") : title;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)adjustedTitle, (String)value, (String)Messages.UIUtils_dontShowAgain, (boolean)false, null, null);
        if (dialog.getToggleState()) {
            editorPrefs.putBoolean(key, true);
            try {
                editorPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return dialog.getReturnCode();
    }

    public static ViewerCell getAdjustedViewerCell(Event event, TableViewer aViewer) {
        ViewerCell viewerCellAdjusted = null;
        Widget widget = event.widget;
        if (widget instanceof Table) {
            Table tableEvent = (Table)widget;
            Rectangle clientArea = tableEvent.getClientArea();
            Point adjustedPoint = new Point(event.x + clientArea.x, event.y);
            viewerCellAdjusted = aViewer.getCell(adjustedPoint);
        }
        return viewerCellAdjusted;
    }
}

