/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ProcessLauncher;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildProcessManager {
    protected OutputStream out;
    protected OutputStream err;
    protected boolean show;
    protected Vector<ProcessLauncher> processes;
    protected int maxProcesses;

    public BuildProcessManager(OutputStream _out, OutputStream _err, boolean _show, int _procNumber) {
        this.out = _out;
        this.err = _err;
        this.show = _show;
        this.maxProcesses = _procNumber;
        this.processes = new Vector(Math.min(10, this.maxProcesses), 10);
    }

    public int getMaxProcesses() {
        return this.maxProcesses;
    }

    public ProcessLauncher launchProcess(IBuildCommand cmd, IPath cwd, IProgressMonitor monitor) {
        int i = 0;
        while (i < this.maxProcesses) {
            if (i >= this.processes.size()) {
                ProcessLauncher process = new ProcessLauncher(cmd.getCommand(), cmd.getArgs(), this.mapToStringArray(cmd.getEnvironment()), cwd, this.out, this.err, monitor, this.show);
                this.processes.add(process);
                process.launch();
                return process;
            }
            if (this.processes.get(i).queryState() == 0) {
                ProcessLauncher process = new ProcessLauncher(cmd.getCommand(), cmd.getArgs(), this.mapToStringArray(cmd.getEnvironment()), cwd, this.out, this.err, monitor, this.show);
                this.processes.set(i, process);
                process.launch();
                return process;
            }
            ++i;
        }
        return null;
    }

    public ProcessLauncher queryStates() {
        for (ProcessLauncher process : this.processes) {
            int state = process.queryState();
            if (state == 1 || state == 0) continue;
            return process;
        }
        return null;
    }

    public boolean hasEmpty() {
        if (this.processes.size() < this.maxProcesses) {
            return true;
        }
        for (ProcessLauncher process : this.processes) {
            if (process.queryState() == 1) continue;
            return true;
        }
        return false;
    }

    public int getThreadsUsed() {
        return this.processes.size();
    }

    protected String[] mapToStringArray(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            list.add(String.valueOf(entry.getKey()) + '=' + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    @Deprecated
    public static int checkCPUNumber() {
        return Runtime.getRuntime().availableProcessors();
    }
}

