/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.StandardBuildConfiguration;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakefileBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.make.core.provider";

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        return new StandardBuildConfiguration(config, name);
    }

    public ICBuildConfiguration createBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, IProgressMonitor monitor) throws CoreException {
        String arch;
        ICBuildConfigurationManager configManager = MakeCorePlugin.getService(ICBuildConfigurationManager.class);
        StringBuilder configName = new StringBuilder("make.");
        configName.append(launchMode);
        String os = toolChain.getProperty("os");
        if (os != null) {
            configName.append('.');
            configName.append(os);
        }
        if ((arch = toolChain.getProperty("arch")) != null && !arch.isEmpty()) {
            configName.append('.');
            configName.append(arch);
        }
        String name = configName.toString();
        int i = 0;
        while (configManager.hasConfiguration((ICBuildConfigurationProvider)this, project, name)) {
            name = String.valueOf(configName.toString()) + '.' + ++i;
        }
        IBuildConfiguration config = configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, name, monitor);
        StandardBuildConfiguration makeConfig = new StandardBuildConfiguration(config, name, toolChain, launchMode);
        configManager.addBuildConfiguration(config, (ICBuildConfiguration)makeConfig);
        return makeConfig;
    }
}

