/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.Map;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NamespaceMappingDialog
extends StatusDialog {
    protected static final String NS_PREFIX = "ns";
    protected EObject modelObject;
    protected Text fTargetNamespace;
    protected Text fPrefixName;
    protected Map<String, String> fNamespaceMappings;
    private String fTargetNamespaceValue = "";
    protected String fPrefixValue = "";

    private NamespaceMappingDialog(Shell parent) {
        super(parent);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
    }

    public NamespaceMappingDialog(Shell parent, EObject eObject) {
        this(parent);
        this.setStatusLineAboveButtons(true);
        this.modelObject = eObject;
        this.setTitle(Messages.NamespaceMappingDialog_3);
        this.computeNamespacePrefix();
    }

    public void setNamespace(String namespace) {
        this.fTargetNamespaceValue = namespace;
        if (this.fTargetNamespace != null && this.fTargetNamespaceValue != null) {
            this.fTargetNamespace.setText(namespace);
        }
    }

    public void computeNamespacePrefix() {
        if (this.fNamespaceMappings == null) {
            this.fNamespaceMappings = BPELUtils.getAllNamespacesForContext((EObject)this.modelObject);
        }
        String key = NS_PREFIX;
        int i = 1;
        while (this.fNamespaceMappings.containsKey(key = NS_PREFIX + i)) {
            ++i;
        }
        this.setPrefix(key);
    }

    public void setPrefix(String value) {
        this.fPrefixValue = value;
        if (this.fPrefixName != null && this.fPrefixValue != null) {
            this.fPrefixName.setText(this.fPrefixValue);
            this.validatePrefix();
        }
    }

    public String getPrefix() {
        return this.fPrefixValue;
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createNamespaceArea(contents);
        return contents;
    }

    protected void createNamespaceArea(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.NamespaceMappingDialog_4);
        GridLayout layout = new GridLayout(1, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        Composite container = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        container.setLayoutData((Object)data);
        Composite namespace = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        namespace.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        namespace.setLayoutData((Object)data);
        Label label = new Label(namespace, 0);
        label.setText(Messages.NamespaceMappingDialog_5);
        this.fTargetNamespace = new Text(namespace, 2048);
        this.fTargetNamespace.setEditable(false);
        this.setNamespace(this.fTargetNamespaceValue);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fTargetNamespace.setLayoutData((Object)data);
        label = new Label(namespace, 0);
        label.setText(Messages.NamespaceMappingDialog_6);
        this.fPrefixName = new Text(namespace, 2048);
        this.setPrefix(this.fPrefixValue);
        this.fPrefixName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamespaceMappingDialog.this.validatePrefix();
            }
        });
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fPrefixName.setLayoutData((Object)data);
    }

    void validatePrefix() {
        this.fPrefixValue = this.fPrefixName.getText();
        if (this.fPrefixValue.length() == 0 || this.fPrefixValue.startsWith("xml")) {
            this.updateStatus((IStatus)new Status(4, BPELUIPlugin.INSTANCE.getID(), 0, Messages.NamespaceMappingDialog_8, null));
            return;
        }
        if (this.fNamespaceMappings.containsKey(this.fPrefixValue)) {
            this.updateStatus((IStatus)new Status(4, BPELUIPlugin.INSTANCE.getID(), 0, Messages.NamespaceMappingDialog_9, null));
            return;
        }
        char[] cArray = this.fPrefixValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isWhitespace(ch)) {
                this.updateStatus((IStatus)new Status(4, BPELUIPlugin.INSTANCE.getID(), 0, Messages.NamespaceMappingDialog_8, null));
                return;
            }
            ++n2;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
    }
}

