/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.WSDLImportResolver;
import org.eclipse.bpel.model.util.XSDImportResolver;

public class ImportResolverRegistry {
    public static final ImportResolverRegistry INSTANCE = new ImportResolverRegistry();
    Map<String, List<ImportResolver>> registry = new HashMap<String, List<ImportResolver>>();
    static final ImportResolver[] EMPTY_RESOLVER_ARRAY = new ImportResolver[0];

    private ImportResolverRegistry() {
        this.registerResolver(new XSDImportResolver());
        this.registerResolver(new WSDLImportResolver());
    }

    public void registerResolver(ImportResolver resolver) {
        String importType = resolver.getImportType();
        List<ImportResolver> resolvers = this.registry.get(importType);
        if (resolvers == null) {
            resolvers = new ArrayList<ImportResolver>();
            this.registry.put(importType, resolvers);
        }
        resolvers.add(resolver);
    }

    public ImportResolver[] getResolvers(String importType) {
        List<ImportResolver> resolvers = this.registry.get(importType);
        if (resolvers == null) {
            return EMPTY_RESOLVER_ARRAY;
        }
        return resolvers.toArray(EMPTY_RESOLVER_ARRAY);
    }
}

