/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.resource.BPELReader;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.resource.BPELWriter;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELProxyURI;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.ImportResolverRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class BPELResourceImpl
extends XMLResourceImpl
implements BPELResource {
    protected static boolean USE_IMPORTS = false;
    private String processNamespaceURI = BPELConstants.NAMESPACE;
    private boolean optionUseNSPrefix = true;
    protected boolean validating = false;
    protected EntityResolver entityResolver = null;
    protected ErrorHandler errorHandler = null;

    public BPELResourceImpl() {
    }

    public BPELResourceImpl(URI arg0) {
        super(arg0);
    }

    public BPELResourceImpl(URI uri, EntityResolver entityResolver, ErrorHandler errorHandler) throws IOException {
        super(uri);
        this.entityResolver = entityResolver;
        this.errorHandler = errorHandler;
        this.validating = true;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.validating = true;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void doSave(OutputStream out, Map<?, ?> args) throws IOException {
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)this.getProcess());
        if (this.getOptionUseNSPrefix()) {
            nsMap.remove("");
            List<String> prefix = nsMap.getReverse(this.getNamespaceURI());
            if (prefix.isEmpty()) {
                nsMap.put("bpel", this.getNamespaceURI());
            }
        } else {
            nsMap.put("", this.getNamespaceURI());
        }
        BPELWriter writer = new BPELWriter();
        writer.write(this, out, args);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        Element processElement;
        BPELReader reader = null;
        Document document = null;
        if (options != null && (document = (Document)options.get("DOMDocument")) != null) {
            reader = new BPELReader();
            reader.read((BPELResource)this, document);
        } else {
            try {
                reader = new BPELReader(this.getDOMParser());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                throw new IOException("Problem create parser");
            }
            reader.read((BPELResource)this, inputStream);
        }
        Element element = processElement = document != null ? document.getDocumentElement() : null;
        if (processElement != null && reader.isAbstractProcess(processElement)) {
            this.setNamespaceURI("http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
            if (reader.getProfileNamespace(processElement) != null) {
                this.getProcess().setAbstractProcessProfile(reader.getProfileNamespace(processElement));
            } else {
                this.getProcess().setAbstractProcessProfile(BPELConstants.NAMESPACE_ABSTRACT_PROFILE);
            }
        } else {
            this.setNamespaceURI(BPELConstants.NAMESPACE);
        }
        boolean usePrefix = this.checkUseNSPrefix("http://schemas.xmlsoap.org/ws/2004/03/business-process/") || this.checkUseNSPrefix("http://docs.oasis-open.org/wsbpel/2.0/process/executable") || this.checkUseNSPrefix("http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
        this.setOptionUseNSPrefix(usePrefix);
    }

    private boolean checkUseNSPrefix(String bpelNamespace) {
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)this.getProcess());
        List<String> prefixes = nsMap.getReverse(bpelNamespace);
        int i = 0;
        while (i < prefixes.size()) {
            String ns = prefixes.get(i);
            if (ns != null && !ns.equals("")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getURIFragment(EObject eObject) {
        return super.getURIFragment(eObject);
    }

    public EObject getEObject(String uriFragment) {
        if (uriFragment == null) {
            return null;
        }
        EObject eObject = super.getEObject(uriFragment);
        if (eObject != null) {
            return eObject;
        }
        eObject = this.getEObjectExtended(uriFragment);
        if (eObject != null) {
            return eObject;
        }
        return null;
    }

    protected EObject getEObjectExtended(String uriFragment) {
        BPELProxyURI proxyURI = new BPELProxyURI(uriFragment);
        QName qname = proxyURI.getQName();
        String typeName = proxyURI.getTypeName();
        if (qname == null || typeName == null) {
            return null;
        }
        EObject result = null;
        Process process = this.getProcess();
        if (process == null) {
            return result;
        }
        for (Import imp : process.getImports()) {
            String ns = imp.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(qname.getNamespaceURI()) || imp.getLocation() == null) continue;
            ImportResolver[] importResolverArray = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n = importResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportResolver r = importResolverArray[n2];
                result = r.resolve(imp, qname, proxyURI.getID(), proxyURI.getTypeName());
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        return result;
    }

    public List<XSDSchema> getSchemas(boolean bIncludeXSD) {
        ArrayList<XSDSchema> al = new ArrayList<XSDSchema>(8);
        Process process = this.getProcess();
        if (process == null) {
            return al;
        }
        for (Import imp : process.getImports()) {
            if (imp.getLocation() == null) continue;
            ImportResolver[] importResolverArray = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n = importResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportResolver r = importResolverArray[n2];
                al.addAll(r.resolve(imp, 1));
                ++n2;
            }
        }
        if (bIncludeXSD) {
            al.add(XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema"));
        }
        return al;
    }

    public List<Definition> getDefinitions() {
        ArrayList<Definition> al = new ArrayList<Definition>(8);
        Process process = this.getProcess();
        if (process == null) {
            return al;
        }
        for (Import imp : process.getImports()) {
            if (imp.getLocation() == null) continue;
            ImportResolver[] importResolverArray = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n = importResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportResolver r = importResolverArray[n2];
                al.addAll(r.resolve(imp, 2));
                ++n2;
            }
        }
        return al;
    }

    @Override
    public Process getProcess() {
        return this.getContents().size() == 1 && this.getContents().get(0) instanceof Process ? (Process)this.getContents().get(0) : null;
    }

    protected DocumentBuilder getDocumentBuilder() throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        if (this.validating && factory.getClass().getName().indexOf("org.apache.xerces") != -1) {
            factory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
            factory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
            factory.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", BPELConstants.NAMESPACE);
        }
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(this.validating);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new IOException(exc.toString());
        }
        if (this.validating) {
            builder.setEntityResolver(this.entityResolver);
            builder.setErrorHandler(this.errorHandler);
        }
        return builder;
    }

    protected DOMParser getDOMParser() throws Exception {
        DOMParser domParser = new DOMParser(){
            protected XMLLocator mLocator;
            protected int fLineNo = 0;
            protected int fColumnNo = 0;
            protected int fOffset = 0;

            void lastSource() {
                this.fLineNo = this.mLocator.getLineNumber();
                this.fColumnNo = this.mLocator.getColumnNumber();
                this.fOffset = this.mLocator.getCharacterOffset();
            }

            public void startDocument(XMLLocator arg0, String arg1, NamespaceContext arg2, Augmentations arg3) throws XNIException {
                this.mLocator = arg0;
                super.startDocument(arg0, arg1, arg2, arg3);
                this.lastSource();
            }

            public void characters(XMLString arg0, Augmentations arg1) throws XNIException {
                super.characters(arg0, arg1);
                this.lastSource();
            }

            public void comment(XMLString arg0, Augmentations arg1) throws XNIException {
                super.comment(arg0, arg1);
                this.lastSource();
            }

            public void textDecl(String arg0, String arg1, Augmentations arg2) throws XNIException {
                super.textDecl(arg0, arg1, arg2);
                this.lastSource();
            }

            public void startElement(org.apache.xerces.xni.QName arg0, XMLAttributes arg1, Augmentations arg2) throws XNIException {
                super.startElement(arg0, arg1, arg2);
                if (this.fCurrentNode != null) {
                    this.fCurrentNode.setUserData("location.line", this.fLineNo, null);
                    this.fCurrentNode.setUserData("location.column", this.fColumnNo, null);
                    this.fCurrentNode.setUserData("location.charStart", this.fOffset + 1, null);
                    this.fCurrentNode.setUserData("location.charEnd", this.fOffset + arg0.rawname.length() + 1, null);
                    this.fCurrentNode.setUserData("location2.line", this.mLocator.getLineNumber(), null);
                    this.fCurrentNode.setUserData("location2.column", this.mLocator.getColumnNumber(), null);
                    this.fCurrentNode.setUserData("location2.charStart", this.mLocator.getCharacterOffset(), null);
                    this.fCurrentNode.setUserData("location2.charEnd", this.mLocator.getCharacterOffset(), null);
                }
                this.lastSource();
            }

            public void startCDATA(Augmentations aug) {
                super.startCDATA(aug);
                this.lastSource();
            }

            public void endCDATA(Augmentations aug) {
                super.endCDATA(aug);
                this.lastSource();
            }

            public void endElement(org.apache.xerces.xni.QName element, Augmentations aug) {
                super.endElement(element, aug);
                this.lastSource();
            }
        };
        if (this.validating) {
            domParser.setFeature("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE.booleanValue());
            domParser.setFeature("http://apache.org/xml/features/validation/schema", Boolean.TRUE.booleanValue());
            domParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)BPELConstants.NAMESPACE);
        }
        domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        domParser.setFeature("http://apache.org/xml/features/xinclude", false);
        if (this.validating) {
            domParser.setEntityResolver(this.entityResolver);
            domParser.setErrorHandler(this.errorHandler);
        }
        return domParser;
    }

    public static void setUseImports(boolean useImports) {
        USE_IMPORTS = useImports;
    }

    @Override
    public String getNamespaceURI() {
        return this.processNamespaceURI;
    }

    @Override
    public void setNamespaceURI(String namespaceURI) {
        this.processNamespaceURI = namespaceURI;
    }

    @Override
    public boolean getOptionUseNSPrefix() {
        return this.optionUseNSPrefix;
    }

    @Override
    public void setOptionUseNSPrefix(boolean useNSPrefix) {
        this.optionUseNSPrefix = useNSPrefix;
    }
}

