/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import java.io.File;
import java.io.IOException;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.common.ui.editmodel.SynchronizationHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;

class SynchronizationManager {
    private ActivationListener partListener;

    public SynchronizationManager(IEditorPart editor, EditModel editModel, SynchronizationHandler handler) {
        this.partListener = new ActivationListener(this, editor, handler, editModel);
        editor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partListener);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.partListener);
    }

    protected void dispose() {
        if (this.partListener.editor == null) {
            throw new IllegalArgumentException("editor cannot be null");
        }
        this.partListener.editor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partListener);
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.partListener);
    }

    private static class ActivationListener
    implements IPartListener,
    IWindowListener {
        private boolean handlingActivation = false;
        private IWorkbenchPart activePart = null;
        private SynchronizationManager manager;
        private IEditorPart editor;
        private SynchronizationHandler handler;
        private EditModel editModel;

        ActivationListener(SynchronizationManager manager, IEditorPart editor, SynchronizationHandler handler, EditModel editModel) {
            this.editModel = editModel;
            this.manager = manager;
            this.editor = editor;
            this.handler = handler;
        }

        public void partActivated(IWorkbenchPart part) {
            this.activePart = part;
            this.handleActivated();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart && this.editor == part) {
                this.manager.dispose();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.activePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (!this.handlingActivation) {
                this.handleActivated();
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (this.editor.getSite().getWorkbenchWindow() == window) {
                this.manager.dispose();
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        void handleActivated() {
            if (this.editor == this.activePart) {
                this.handlingActivation = true;
                try {
                    ResourceInfo[] resourceInfos = this.editModel.getResourceInfos();
                    int i = 0;
                    while (i < resourceInfos.length) {
                        this.handleActivated(resourceInfos[i]);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    CommonUIPlugin.log((Exception)((Object)e));
                }
                catch (IOException e) {
                    CommonUIPlugin.log(e);
                }
                this.handlingActivation = false;
            }
        }

        void handleActivated(ResourceInfo resourceInfo) throws CoreException, IOException {
            block8: {
                boolean exists = false;
                long lastModified = 0L;
                IPath location = resourceInfo.getFile().getLocation();
                if (location != null) {
                    File localFile = location.toFile();
                    exists = localFile.exists();
                    lastModified = localFile.lastModified();
                }
                if (resourceInfo.getFileExists() && !exists) {
                    MessageDialog dialog;
                    String[] buttons = new String[]{Messages.SynchronizationManager_saveButtonLabel, IDialogConstants.CLOSE_LABEL};
                    while ((dialog = new MessageDialog(this.editor.getEditorSite().getShell(), Messages.SynchronizationManager_deleted_title, null, Messages.SynchronizationManager_deleted_message, 3, buttons, 0)).open() == 0) {
                        boolean saveSuccess;
                        SaveAsDialog saveAsDialog = new SaveAsDialog(this.editor.getEditorSite().getShell());
                        saveAsDialog.setOriginalFile(resourceInfo.getFile());
                        saveAsDialog.open();
                        IPath path = saveAsDialog.getResult();
                        if (path == null || !(saveSuccess = this.handler.saveFileAs(resourceInfo, ResourcesPlugin.getWorkspace().getRoot().getFile(path)))) continue;
                        resourceInfo.resetSynchronizeStamp();
                        break block8;
                    }
                    this.handler.closeEditor();
                } else if (lastModified != resourceInfo.getSynchronizeStamp()) {
                    String msg = NLS.bind((String)Messages.SynchronizationManager_refresh_message, (Object[])new String[]{resourceInfo.getFile().toString()});
                    boolean refresh = MessageDialog.openQuestion((Shell)this.editor.getEditorSite().getShell(), (String)Messages.SynchronizationManager_refresh_title, (String)msg);
                    if (refresh) {
                        this.handler.refresh(resourceInfo);
                        resourceInfo.resetSynchronizeStamp();
                    } else {
                        resourceInfo.resetSynchronizeStamp();
                    }
                }
            }
            IFile file = resourceInfo.getFile();
            if (!(!file.exists() || file.isLocal(0) && resourceInfo.getFile().isSynchronized(0))) {
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

