/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.calendar.CalendarPopup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatePicker
extends Composite {
    private static final int DEFAULT_DATE_STYLE = 3;
    private int dateStyle = 3;
    Text dateDisplayField;
    private Button showCalendarButton;

    public DatePicker(Composite parent) {
        super(parent, 0);
        this.createControls();
        this.hookControlListeners();
    }

    private void createControls() {
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 3;
        this.setLayout((Layout)gl);
        this.dateDisplayField = new Text((Composite)this, 2052);
        this.dateDisplayField.setText(this.getDateDisplayString(new Date()));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.dateDisplayField.setLayoutData((Object)gd);
        this.showCalendarButton = new Button((Composite)this, 8);
        this.showCalendarButton.setText(Messages.DatePicker_button_text);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 1;
        this.showCalendarButton.setLayoutData((Object)gd);
    }

    private void hookControlListeners() {
        this.showCalendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.setDate(CalendarPopup.openCalendarPopup((Control)DatePicker.this.dateDisplayField, DatePicker.this.getDate()));
            }
        });
    }

    private String getDateDisplayString(Date date) {
        if (date != null) {
            DateFormat formatter = DateFormat.getDateInstance(this.dateStyle);
            return formatter.format(date);
        }
        return Messages.DatePicker_noDateSelected;
    }

    public int getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(int style) {
        this.dateStyle = style;
    }

    public Image getImage() {
        return this.showCalendarButton.getImage();
    }

    public void setImage(Image image) {
        this.showCalendarButton.setImage(image);
        if (image != null) {
            this.showCalendarButton.setText("");
        } else {
            this.showCalendarButton.setText(Messages.DatePicker_button_text);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public Date getDate() {
        try {
            DateFormat formatter = DateFormat.getDateInstance(this.dateStyle);
            return formatter.parse(this.dateDisplayField.getText());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setDate(Date date) {
        this.dateDisplayField.setText(this.getDateDisplayString(date));
    }
}

