/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editor.script;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.editors.script.ScriptParser;
import org.eclipse.birt.report.designer.internal.ui.script.ScriptValidator;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptProjectionAnnotation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Display;

public class ScriptReconcilingStrategy
implements IReconcilingStrategy {
    private final ISourceViewer viewer;
    private final ScriptValidator validator;

    public ScriptReconcilingStrategy(ISourceViewer sourceViewer) {
        this.viewer = sourceViewer;
        this.validator = new ScriptValidator(sourceViewer);
    }

    public void reconcile(IRegion partition) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScriptReconcilingStrategy.this.validate();
                ScriptReconcilingStrategy.this.updateFoldingStructure();
            }
        });
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setDocument(IDocument document) {
    }

    protected void validate() {
        try {
            this.validator.validate(true, false);
        }
        catch (ParseException parseException) {
            return;
        }
    }

    protected void updateFoldingStructure() {
        if (!(this.viewer instanceof ProjectionViewer)) {
            return;
        }
        ProjectionAnnotationModel annotationModel = ((ProjectionViewer)this.viewer).getProjectionAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        HashSet positions = new HashSet();
        IDocument document = this.viewer.getDocument();
        ScriptParser parser = new ScriptParser(document == null ? null : document.get());
        Collection comments = parser.getCommentPositions();
        Collection methods = parser.getMethodPositions();
        positions.addAll(comments);
        positions.addAll(methods);
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof ScriptProjectionAnnotation) || positions.remove(annotationModel.getPosition(annotation))) continue;
            annotationModel.removeAnnotation(annotation);
        }
        for (Position position : positions) {
            ScriptProjectionAnnotation annotation = new ScriptProjectionAnnotation(comments.contains(position) ? 1 : (methods.contains(position) ? 2 : 0));
            annotationModel.addAnnotation((Annotation)annotation, position);
        }
    }
}

