/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.actf.model.flash.util.SwfHeaderParser;
import org.eclipse.actf.model.flash.util.SwfInfo;

public class AsVersionChecker {
    public static final int READBUFFER_SIZE = 0x100000;
    private static final Logger LOGGER = Logger.getLogger(AsVersionChecker.class.getName());
    private URL url;
    private InputStream in;

    public void setSwfFile(String string) {
        try {
            File file = new File(string);
            this.url = file.exists() ? file.toURI().toURL() : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            this.url = null;
        }
    }

    public void setSwfFile(URL uRL) {
        this.url = uRL;
    }

    public void setSwfFile(InputStream inputStream) {
        this.in = inputStream;
        this.url = null;
    }

    public SwfInfo getSwfInfo() {
        SwfInfo swfInfo = new SwfInfo();
        try {
            InputStream inputStream;
            if (this.url == null) {
                if (this.in == null) {
                    return swfInfo;
                }
                inputStream = this.in;
            } else {
                inputStream = this.url.openConnection().getInputStream();
            }
            MyBufferedInputStream myBufferedInputStream = new MyBufferedInputStream(inputStream, 0x100000);
            SwfHeaderParser swfHeaderParser = new SwfHeaderParser(myBufferedInputStream);
            swfHeaderParser.parse();
            swfInfo.setFrameSizeX(swfHeaderParser.getFrameSizeX());
            swfInfo.setFrameSizeY(swfHeaderParser.getFrameSizeY());
            inputStream = swfHeaderParser.getInputStream();
            LOGGER.fine("searching AS related tag...");
            while (true) {
                byte[] byArray = this.readBytes(inputStream, 2);
                int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                LOGGER.fine("**" + Integer.toHexString(n));
                int n2 = n >> 6;
                int n3 = n & 0x3F;
                if (n3 == 63) {
                    byArray = this.readBytes(inputStream, 4);
                    n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
                }
                LOGGER.fine("type=" + n2 + ", length=" + n3);
                if (n2 == 0) {
                    this.pushBack(myBufferedInputStream.getBuffer());
                    swfInfo.setAsVersion(-1);
                    return swfInfo;
                }
                if (n2 == 69) {
                    byArray = this.readBytes(inputStream, 1);
                    if ((byArray[0] & 8) > 0) {
                        this.pushBack(myBufferedInputStream.getBuffer());
                        swfInfo.setAsVersion(3);
                        return swfInfo;
                    }
                    this.pushBack(myBufferedInputStream.getBuffer());
                    swfInfo.setAsVersion(2);
                    return swfInfo;
                }
                if (n2 == 59 || n2 == 12) {
                    this.pushBack(myBufferedInputStream.getBuffer());
                    swfInfo.setAsVersion(2);
                    return swfInfo;
                }
                if (n2 == 82) {
                    this.pushBack(myBufferedInputStream.getBuffer());
                    swfInfo.setAsVersion(3);
                    continue;
                }
                this.readBytes(inputStream, n3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            swfInfo.setAsVersion(-1);
            return swfInfo;
        }
    }

    private byte[] readBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        return byArray;
    }

    private void pushBack(byte[] byArray) throws IOException {
        if (this.in instanceof PushbackInputStream) {
            PushbackInputStream pushbackInputStream = (PushbackInputStream)this.in;
            pushbackInputStream.unread(byArray);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        LOGGER.info("started");
        System.out.println("1 - AS3, 2 - AS3 no compress, 3 - AS2\n?");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        int n = Integer.parseInt(bufferedReader.readLine());
        AsVersionChecker asVersionChecker = new AsVersionChecker();
        if (n == 1) {
            asVersionChecker.setSwfFile("checker/f9as3.swf");
        } else if (n == 2) {
            asVersionChecker.setSwfFile("checker/f9as3-noc.swf");
        } else {
            asVersionChecker.setSwfFile("checker/f9as2.swf");
        }
        int n2 = asVersionChecker.getSwfInfo().getAsVersion();
        LOGGER.info("version=" + n2);
    }

    private class MyBufferedInputStream
    extends BufferedInputStream {
        public MyBufferedInputStream(InputStream inputStream, int n) {
            super(inputStream, n);
            super.mark(n);
        }

        public byte[] getBuffer() {
            if (this.markpos == 0) {
                byte[] byArray = new byte[this.count];
                System.arraycopy(this.buf, 0, byArray, 0, this.count);
                return byArray;
            }
            LOGGER.severe("load size over: " + this.buf.length);
            return new byte[0];
        }
    }
}

