/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.SeqGenerator;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.V8MessageType;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

public class DebuggerMessage
implements JSONStreamAware {
    private final int sequence;
    private final String command;
    private final Map<String, Object> arguments = new HashMap<String, Object>();

    public DebuggerMessage(String command) {
        this.sequence = SeqGenerator.getInstance().next();
        this.command = command;
    }

    public Integer getSeq() {
        return this.sequence;
    }

    public String getType() {
        return V8MessageType.REQUEST.value;
    }

    public String getCommand() {
        return this.command;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    protected final void putArgument(String key, Object object) {
        if (object != null) {
            this.arguments.put(key, object);
        }
    }

    protected final void putNullableArgument(String key, Object object) {
        this.arguments.put(key, object);
    }

    private final void putArgumentString(String key, Object object) {
        this.arguments.put(key, object.toString());
    }

    protected final void putArgumentStringIfNotNull(String key, Object object) {
        if (object != null) {
            this.putArgumentString(key, object);
        }
    }

    public void writeJSONString(Writer out) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("seq", this.sequence);
        obj.put("type", V8MessageType.REQUEST.value);
        obj.put("command", this.command);
        if (!this.arguments.isEmpty()) {
            obj.put("arguments", this.arguments);
        }
        JSONValue.writeJSONString(obj, (Writer)out);
    }
}

