/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model.beans;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.model.reference.StringReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanSupport;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.XmlElementBeanBindableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeansObserveTypeContainer
extends ObserveTypeContainer {
    public static final String NAMESPACE_KEY = "xmlns:";
    private static final String NAMESPACE_VALUE = "clr-namespace:";
    private XmlObjectInfo m_xmlObjectRoot;
    private List<BeanBindableInfo> m_observables = Collections.emptyList();
    private BeanBindableInfo m_dataContext;

    public BeansObserveTypeContainer() {
        super(ObserveType.BEANS, false, true);
    }

    @Override
    public void createObservables(XmlObjectInfo xmlObjectRoot) throws Exception {
        this.m_observables = Lists.newArrayList();
        this.m_xmlObjectRoot = xmlObjectRoot;
        final ClassLoader classLoader = this.m_xmlObjectRoot.getContext().getClassLoader();
        final BeanSupport beanSupport = new BeanSupport(classLoader, null);
        final Class<?> BindingContextClass = classLoader.loadClass("org.eclipse.e4.xwt.databinding.BindingContext");
        DocumentElement rootElement = this.m_xmlObjectRoot.getElement();
        final HashMap namespaceToPackage = Maps.newHashMap();
        final String[] xKey = new String[1];
        final String[] dataContextReference = new String[1];
        for (DocumentAttribute attribute : rootElement.getDocumentAttributes()) {
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.startsWith(NAMESPACE_KEY)) {
                if (value.startsWith(NAMESPACE_VALUE)) {
                    namespaceToPackage.put(name.substring(NAMESPACE_KEY.length()), value.substring(NAMESPACE_VALUE.length()));
                    continue;
                }
                if (!value.equals("http://www.eclipse.org/xwt")) continue;
                xKey[0] = String.valueOf(name.substring(NAMESPACE_KEY.length())) + ":Key";
                continue;
            }
            if (!name.equalsIgnoreCase("DataContext")) continue;
            dataContextReference[0] = StringUtils.substringBetween((String)value, (String)"{StaticResource", (String)"}").trim();
        }
        rootElement.accept(new DocumentModelVisitor(){

            public boolean visit(DocumentElement element) {
                if (element.getTag().endsWith(".Resources")) {
                    for (DocumentElement child : element.getChildren()) {
                        try {
                            String elementName = child.getTag();
                            Class beanClass = null;
                            if (elementName.equalsIgnoreCase("BindingContext")) {
                                beanClass = BindingContextClass;
                            } else {
                                int index = elementName.indexOf(58);
                                String beanClassName = String.valueOf((String)namespaceToPackage.get(elementName.substring(0, index))) + "." + elementName.substring(index + 1);
                                beanClass = CoreUtils.load((ClassLoader)classLoader, (String)beanClassName);
                            }
                            StringReferenceProvider referenceProvider = new StringReferenceProvider(child.getAttribute(xKey[0]));
                            boolean dataContext = referenceProvider.getReference().equals(dataContextReference[0]);
                            XmlElementBeanBindableInfo bindable = new XmlElementBeanBindableInfo(beanSupport, beanClass, (IReferenceProvider)referenceProvider, null, dataContext);
                            BeansObserveTypeContainer.this.m_observables.add(bindable);
                            if (!dataContext) continue;
                            BeansObserveTypeContainer.this.m_dataContext = bindable;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            BeansObserveTypeContainer.this.m_xmlObjectRoot.getContext().addWarning(new EditorWarning("ClassNotFoundException: " + element, new Throwable()));
                        }
                        catch (Throwable e) {
                            throw ReflectionUtils.propagate((Throwable)e);
                        }
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public List<IObserveInfo> getObservables() {
        return CoreUtils.cast(this.m_observables);
    }

    public List<BeanBindableInfo> getObservables0() {
        return this.m_observables;
    }

    public BeanBindableInfo getDataContext() {
        return this.m_dataContext;
    }

    public final BindableInfo resolve(String reference) throws Exception {
        for (BeanBindableInfo bindable : this.m_observables) {
            BindableInfo result = bindable.resolveReference(reference);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

