/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.property;

import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractBindingProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractObserveProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class SingleObserveBindingProperty
extends AbstractProperty {
    private static final TextDialogPropertyEditor EDITOR = new TextDialogPropertyEditor(){

        protected String getText(Property property) throws Exception {
            SingleObserveBindingProperty observeProperty = (SingleObserveBindingProperty)property;
            return observeProperty.getText();
        }

        protected void openDialog(Property property) throws Exception {
            SingleObserveBindingProperty observeProperty = (SingleObserveBindingProperty)property;
            observeProperty.editBinding();
        }
    };
    protected final IObserveInfo m_observeProperty;
    private final String m_title;

    public SingleObserveBindingProperty(Context context, IObserveInfo observeProperty) throws Exception {
        super((PropertyEditor)EDITOR, context);
        this.m_observeProperty = observeProperty;
        this.m_title = this.m_observeProperty.getPresentation().getText();
    }

    public final IObserveInfo getObserveProperty() {
        return this.m_observeProperty;
    }

    public final void editBinding() throws Exception {
        IBindingInfo binding = this.getBinding();
        if (binding == null) {
            AbstractObserveProperty.createBinding(this.m_context, this.m_observeProperty);
        } else {
            AbstractBindingProperty.editBinding(this.m_context, binding);
        }
    }

    protected abstract IBindingInfo getBinding() throws Exception;

    protected abstract String getText() throws Exception;

    public final String getTitle() {
        return this.m_title;
    }

    public final boolean isModified() throws Exception {
        return this.getBinding() != null;
    }

    public final void setValue(Object value) throws Exception {
        Assert.isTrue((value == UNKNOWN_VALUE ? 1 : 0) != 0);
        IBindingInfo binding = this.getBinding();
        if (binding != null) {
            AbstractBindingProperty.deleteBinding(this.m_context, binding);
        }
    }
}

