/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.browser.ViatraQueryToolingBrowserPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.osgi.framework.Bundle;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryRegistryTreeEntry {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryRegistryTreePackage parent;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final IQuerySpecificationRegistryEntry entry;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private boolean isLoaded = false;
  
  public boolean load() {
    boolean _isLoaded = this.isLoaded();
    boolean _not = (!_isLoaded);
    if (_not) {
      try {
        final IQuerySpecification<?> specification = this.entry.get();
        boolean _notEquals = (!Objects.equal(specification, null));
        if (_notEquals) {
          this.isLoaded = true;
        }
        return true;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception ex = (Exception)_t;
          String _fullyQualifiedName = this.entry.getFullyQualifiedName();
          String _message = ex.getMessage();
          final String logMessage = String.format("Query Registry has encountered an error during loading of query %s: %s", _fullyQualifiedName, _message);
          ViatraQueryToolingBrowserPlugin _default = ViatraQueryToolingBrowserPlugin.getDefault();
          ILog _log = _default.getLog();
          ViatraQueryGUIPlugin _default_1 = ViatraQueryGUIPlugin.getDefault();
          Bundle _bundle = _default_1.getBundle();
          String _symbolicName = _bundle.getSymbolicName();
          Status _status = new Status(
            IStatus.ERROR, _symbolicName, logMessage, ex);
          _log.log(_status);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return false;
  }
  
  public String getSimpleName() {
    String _xblockexpression = null;
    {
      final String fqn = this.entry.getFullyQualifiedName();
      final int lastDotIndex = fqn.lastIndexOf(".");
      String _xifexpression = null;
      boolean _and = false;
      if (!(lastDotIndex > 0)) {
        _and = false;
      } else {
        int _length = fqn.length();
        boolean _lessThan = (lastDotIndex < _length);
        _and = _lessThan;
      }
      if (_and) {
        int _length_1 = fqn.length();
        _xifexpression = fqn.substring((lastDotIndex + 1), _length_1);
      } else {
        return fqn;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public String getPackageName() {
    String _xblockexpression = null;
    {
      final String fqn = this.entry.getFullyQualifiedName();
      final int lastDotIndex = fqn.lastIndexOf(".");
      String _xifexpression = null;
      boolean _and = false;
      if (!(lastDotIndex > 0)) {
        _and = false;
      } else {
        int _length = fqn.length();
        boolean _lessThan = (lastDotIndex < _length);
        _and = _lessThan;
      }
      if (_and) {
        int _lastIndexOf = fqn.lastIndexOf(".");
        _xifexpression = fqn.substring(0, _lastIndexOf);
      } else {
        return fqn;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  @Pure
  public QueryRegistryTreePackage getParent() {
    return this.parent;
  }
  
  @Pure
  public IQuerySpecificationRegistryEntry getEntry() {
    return this.entry;
  }
  
  @Pure
  public boolean isLoaded() {
    return this.isLoaded;
  }
  
  public QueryRegistryTreeEntry(final QueryRegistryTreePackage parent, final IQuerySpecificationRegistryEntry entry) {
    super();
    this.parent = parent;
    this.entry = entry;
  }
}
