/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.impl.BaseQueryGroup;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;

public class PackageBasedQueryGroup
extends BaseQueryGroup {
    private final Set<IQuerySpecification<?>> querySpecifications = new HashSet();
    private final String packageName;
    private final boolean includeSubPackages;
    private IRegistryView view;

    public PackageBasedQueryGroup(String packageName) {
        this(packageName, false);
    }

    public PackageBasedQueryGroup(String packageName, boolean includeSubPackages) {
        this.packageName = packageName;
        this.includeSubPackages = includeSubPackages;
        IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
        this.view = registry.createView(new PackageNameBasedViewFilter());
        for (IQuerySpecificationRegistryEntry entry : this.view.getEntries()) {
            this.querySpecifications.add((IQuerySpecification)entry.get());
        }
        SpecificationSetUpdater listener = new SpecificationSetUpdater();
        this.view.addViewListener(listener);
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        return ImmutableSet.copyOf(this.querySpecifications);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<IQuerySpecification<?>> getQuerySpecifications() {
        return this.getSpecifications();
    }

    public boolean isIncludeSubPackages() {
        return this.includeSubPackages;
    }

    public void refresh() {
    }

    private final class PackageNameBasedViewFilter
    implements IRegistryViewFilter {
        private PackageNameBasedViewFilter() {
        }

        @Override
        public boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
            String fqn = entry.getFullyQualifiedName();
            if (PackageBasedQueryGroup.this.packageName.length() + 1 < fqn.length()) {
                if (PackageBasedQueryGroup.this.includeSubPackages) {
                    if (fqn.startsWith(String.valueOf(PackageBasedQueryGroup.this.packageName) + '.')) {
                        return true;
                    }
                } else {
                    String name = fqn.substring(fqn.lastIndexOf(46) + 1, fqn.length());
                    if (fqn.equals(String.valueOf(PackageBasedQueryGroup.this.packageName) + '.' + name)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private final class SpecificationSetUpdater
    implements IQuerySpecificationRegistryChangeListener {
        private SpecificationSetUpdater() {
        }

        @Override
        public void entryAdded(IQuerySpecificationRegistryEntry entry) {
            PackageBasedQueryGroup.this.querySpecifications.add((IQuerySpecification)entry.get());
        }

        @Override
        public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
            PackageBasedQueryGroup.this.querySpecifications.remove(entry.get());
        }
    }
}

