/**
 * Copyright (c) 2010-2016, Grill Balázs, IncQuery Labs Ltd
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl.IndexerBasedConstraintCostFunction;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * This cost function is intended to be used on hybrid configuration, with the strict restriction than any
 * non-flattened positive pattern call is executed with Rete engine. This implementation provides the exact number
 * of matches by invoking the result provider for the called pattern.
 */
@SuppressWarnings("all")
public class HybridMatcherConstraintCostFunction extends IndexerBasedConstraintCostFunction {
  @Override
  protected double _calculateCost(final PositivePatternCall patternCall, final IConstraintEvaluationContext input) {
    try {
      Integer _xblockexpression = null;
      {
        final Tuple variables = patternCall.getVariablesTuple();
        final Set<Object> variablesSet = variables.<Object>getDistinctElements();
        final HashMap<PVariable, Object> constantMap = CollectionLiterals.<PVariable, Object>newHashMap();
        PBody _pSystem = patternCall.getPSystem();
        Set<PConstraint> _constraints = _pSystem.getConstraints();
        final Procedure1<PConstraint> _function = new Procedure1<PConstraint>() {
          @Override
          public void apply(final PConstraint it) {
            if ((it instanceof ConstantValue)) {
              Tuple _variablesTuple = ((ConstantValue)it).getVariablesTuple();
              Object _get = _variablesTuple.get(0);
              final PVariable variable = ((PVariable) _get);
              boolean _and = false;
              boolean _contains = variablesSet.contains(variable);
              if (!_contains) {
                _and = false;
              } else {
                Collection<PVariable> _boundVariables = input.getBoundVariables();
                boolean _contains_1 = _boundVariables.contains(variable);
                _and = _contains_1;
              }
              if (_and) {
                Object _supplierKey = ((ConstantValue)it).getSupplierKey();
                constantMap.put(variable, _supplierKey);
              }
            }
          }
        };
        IterableExtensions.<PConstraint>forEach(_constraints, _function);
        int _size = variables.getSize();
        final Object[] filter = new Object[_size];
        for (int i = 0; (i < variables.getSize()); i++) {
          Object _get = variables.get(i);
          Object _get_1 = constantMap.get(_get);
          filter[i] = _get_1;
        }
        final Map<Object, Integer> variableIndices = variables.invertIndex();
        Collection<PVariable> _boundVariables = input.getBoundVariables();
        final Function1<PVariable, Boolean> _function_1 = new Function1<PVariable, Boolean>() {
          @Override
          public Boolean apply(final PVariable it) {
            boolean _containsKey = constantMap.containsKey(it);
            return Boolean.valueOf((!_containsKey));
          }
        };
        Iterable<PVariable> _filter = IterableExtensions.<PVariable>filter(_boundVariables, _function_1);
        final Function1<PVariable, Integer> _function_2 = new Function1<PVariable, Integer>() {
          @Override
          public Integer apply(final PVariable it) {
            return variableIndices.get(it);
          }
        };
        final Iterable<Integer> aggregateKeys = IterableExtensions.<PVariable, Integer>map(_filter, _function_2);
        IQueryResultProviderAccess _resultProviderAccess = input.resultProviderAccess();
        PQuery _referredQuery = patternCall.getReferredQuery();
        final IQueryResultProvider resultProvider = _resultProviderAccess.getResultProvider(_referredQuery, null);
        final HashMap<Tuple, Integer> aggregatedCounts = CollectionLiterals.<Tuple, Integer>newHashMap();
        Collection<? extends Tuple> _allMatches = resultProvider.getAllMatches(filter);
        Pair<Tuple, Integer> _mappedTo = Pair.<Tuple, Integer>of(((Tuple) null), Integer.valueOf(0));
        final Function2<Pair<Tuple, Integer>, Tuple, Pair<Tuple, Integer>> _function_3 = new Function2<Pair<Tuple, Integer>, Tuple, Pair<Tuple, Integer>>() {
          @Override
          public Pair<Tuple, Integer> apply(final Pair<Tuple, Integer> currentMax, final Tuple match) {
            Pair<Tuple, Integer> _xblockexpression = null;
            {
              final Tuple extracted = HybridMatcherConstraintCostFunction.this.extract(match, aggregateKeys);
              int _xifexpression = (int) 0;
              boolean _containsKey = aggregatedCounts.containsKey(extracted);
              if (_containsKey) {
                Integer _get = aggregatedCounts.get(extracted);
                _xifexpression = ((_get).intValue() + 1);
              } else {
                _xifexpression = 1;
              }
              final int count = _xifexpression;
              Pair<Tuple, Integer> _xifexpression_1 = null;
              boolean _or = false;
              Tuple _key = currentMax.getKey();
              boolean _equals = Objects.equal(_key, null);
              if (_equals) {
                _or = true;
              } else {
                Integer _value = currentMax.getValue();
                boolean _greaterThan = (count > (_value).intValue());
                _or = _greaterThan;
              }
              if (_or) {
                _xifexpression_1 = Pair.<Tuple, Integer>of(extracted, Integer.valueOf(count));
              } else {
                _xifexpression_1 = currentMax;
              }
              _xblockexpression = _xifexpression_1;
            }
            return _xblockexpression;
          }
        };
        Pair<Tuple, Integer> _fold = IterableExtensions.fold(_allMatches, _mappedTo, _function_3);
        _xblockexpression = _fold.getValue();
      }
      return (_xblockexpression).intValue();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private Tuple extract(final Tuple tuple, final Iterable<Integer> indices) {
    final LinkedList<Object> list = CollectionLiterals.<Object>newLinkedList();
    for (final Integer index : indices) {
      Object _get = tuple.get((index).intValue());
      list.add(_get);
    }
    Object[] _array = list.toArray();
    return new FlatTuple(_array);
  }
}
