/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;

public class TmfTreeCompositeDataProvider<M extends ITmfTreeDataModel, P extends ITmfTreeDataProvider<M>>
implements ITmfTreeDataProvider<M> {
    private final List<P> fProviders;
    private final String fId;

    public TmfTreeCompositeDataProvider(List<P> providers, String id) {
        this.fProviders = providers;
        this.fId = id;
    }

    @Override
    public TmfModelResponse<List<M>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ImmutableList.Builder series = ImmutableList.builder();
        for (ITmfTreeDataProvider dataProvider : this.fProviders) {
            TmfModelResponse response = dataProvider.fetchTree(filter, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            List model = response.getModel();
            if (model != null) {
                series.addAll(model);
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<ImmutableList>(series.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<ImmutableList>(series.build(), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    protected List<P> getProviders() {
        return this.fProviders;
    }
}

