/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenValueQuery
extends DataDrivenValue {
    private final List<DataDrivenValue> fQuery;

    public DataDrivenValueQuery(@Nullable String mappingGroupId, ITmfStateValue.Type forcedType, List<DataDrivenValue> query) {
        super(mappingGroupId, forcedType);
        this.fQuery = query;
    }

    @Override
    protected @Nullable Object resolveValue(int quark, IAnalysisDataContainer container) {
        return this.executeQuery(sv -> sv.resolveValue(quark, container), container);
    }

    @Override
    protected @Nullable Object resolveValue(ITmfEvent event, int quark, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        return this.executeQuery(sv -> sv.resolveValue(event, quark, scenarioInfo, container), container);
    }

    private @Nullable Object executeQuery(Function<DataDrivenValue, @Nullable Object> function, IAnalysisDataContainer container) {
        Object value = null;
        int quarkQuery = -1;
        ITmfStateSystem ss = container.getStateSystem();
        for (DataDrivenValue path : this.fQuery) {
            Object attribVal = function.apply(path);
            if (attribVal == null) {
                quarkQuery = -2;
                break;
            }
            if ((quarkQuery = container.getQuarkRelativeAndAdd(quarkQuery, String.valueOf(attribVal))) < 0) break;
        }
        if (quarkQuery >= 0) {
            value = ss.queryOngoing(quarkQuery);
        }
        return value;
    }

    @Override
    public String toString() {
        return "DataDrivenValueQuery: " + this.fQuery;
    }
}

