/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenActionStateChange
extends DataDrivenAction {
    private final DataDrivenValue fRightOperand;
    private final List<DataDrivenValue> fLeftOperand;
    private final boolean fUpdate;
    private final boolean fIncrement;
    private final StackAction fStackAction;

    public DataDrivenActionStateChange(List<DataDrivenValue> leftOperand, DataDrivenValue rightOperand, boolean increment, boolean update, StackAction stackAction) {
        this.fRightOperand = rightOperand;
        this.fLeftOperand = leftOperand;
        this.fUpdate = update;
        this.fIncrement = increment;
        this.fStackAction = stackAction;
    }

    @Override
    public void eventHandle(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        int quark = -1;
        ITmfStateSystem stateSystem = container.getStateSystem();
        if (!(stateSystem instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("With state changes, the state system should be in building mode");
        }
        ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)stateSystem;
        for (DataDrivenValue val : this.fLeftOperand) {
            Object value = val.getValue(event, quark, scenarioInfo, container);
            if (value == null) {
                Activator.logWarning("StateChange.handleEvent: A value is null: " + val);
                return;
            }
            if ((quark = container.getQuarkRelativeAndAdd(quark, String.valueOf(value))) >= 0) continue;
            Activator.logWarning("The attribute quark is invalid for event " + event + ": " + this.fLeftOperand);
            return;
        }
        Object assignVal = this.fRightOperand.getValue(event, -1, scenarioInfo, container);
        long timestamp = event.getTimestamp().toNanos();
        switch (this.fStackAction) {
            case POP: {
                ssb.popAttribute(timestamp, quark);
                return;
            }
            case PUSH: {
                ssb.pushAttribute(timestamp, assignVal, quark);
                return;
            }
            case POP_ALL: {
                Object stackDepth = ssb.queryOngoing(quark);
                if (stackDepth instanceof Integer) {
                    int nbElements = (Integer)stackDepth;
                    int i = 0;
                    while (i < nbElements) {
                        ssb.popAttribute(timestamp, quark);
                        ++i;
                    }
                }
                return;
            }
        }
        if (this.fIncrement && assignVal != null) {
            assignVal = DataDrivenActionStateChange.incrementByType(quark, (ITmfStateSystem)ssb, assignVal);
        }
        if (this.fUpdate) {
            ssb.updateOngoingState((ITmfStateValue)TmfXmlUtils.newTmfStateValueFromObject(assignVal), quark);
        } else {
            ssb.modifyAttribute(timestamp, assignVal, quark);
        }
    }

    private static @Nullable Object incrementByType(int quark, ITmfStateSystem ss, Object stateValue) {
        if (stateValue instanceof Long) {
            Long incrementLong = (Long)stateValue;
            Object currentState = ss.queryOngoing(quark);
            Long currentValue = currentState == null ? 0L : (Long)currentState;
            return incrementLong + currentValue;
        }
        if (stateValue instanceof Integer) {
            Integer incrementLong = (Integer)stateValue;
            Object currentState = ss.queryOngoing(quark);
            Integer currentValue = currentState == null ? 0 : (Integer)currentState;
            return incrementLong + currentValue;
        }
        return stateValue;
    }

    public static enum StackAction {
        NONE,
        PUSH,
        PEEK,
        POP,
        POP_ALL;


        public static StackAction getTypeFromString(String input) {
            switch (input) {
                case "push": {
                    return PUSH;
                }
                case "pop": {
                    return POP;
                }
                case "popAll": {
                    return POP_ALL;
                }
                case "peek": {
                    return PEEK;
                }
            }
            return NONE;
        }
    }
}

