/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.participant;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.participant.BasePaneParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.svn.ui.synchronize.action.DeletePaneAction;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToSVNPaneParticipant
extends BasePaneParticipant {
    public AddToSVNPaneParticipant(ISynchronizeScope scope, IValidationManager validationManager) {
        super(scope, validationManager);
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        ArrayList<AbstractSynchronizeActionGroup> actionGroups = new ArrayList<AbstractSynchronizeActionGroup>();
        actionGroups.add(new AddToSVNPaneActionGroup(this.validationManager));
        return actionGroups;
    }

    protected static class AddToSVNPaneActionGroup
    extends BasePaneParticipant.BasePaneActionGroup {
        public AddToSVNPaneActionGroup(IValidationManager validationManager) {
            super(validationManager);
        }

        protected void configureActions(ISynchronizePageConfiguration configuration) {
            super.configureActions(configuration);
            AddToIgnoreByNameAction addToIgnoreByNameAction = new AddToIgnoreByNameAction(SVNUIMessages.AddToSVNPanel_IgnoreByNames_Multiple, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)addToIgnoreByNameAction);
            AddToIgnoreByExtensionAction addToIgnoreByExtensionAction = new AddToIgnoreByExtensionAction(SVNUIMessages.AddToSVNPanel_IgnoreByExtension_Multiple, configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)addToIgnoreByExtensionAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IContributionItem)new Separator());
            DeletePaneAction deleteAction = new DeletePaneAction(SVNUIMessages.CommitPanel_Delete_Action, configuration);
            deleteAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "syncNormal", (IAction)deleteAction);
        }

        protected static class AddToIgnoreByExtensionAction
        extends AbstractSynchronizeModelAction {
            public AddToIgnoreByExtensionAction(String text, ISynchronizePageConfiguration configuration) {
                super(text, configuration);
            }

            protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                IResource[] selectedResources = this.getAllSelectedResources();
                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                return op;
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                IResource[] selectedResources = this.getAllSelectedResources();
                if (selectedResources.length == 1) {
                    String[] parts = this.getNameParts(selectedResources);
                    this.setText(BaseMessages.format((String)SVNUIMessages.AddToSVNPanel_Ignore_Single, (Object)("*." + parts[parts.length - 1])));
                } else if (selectedResources.length > 1) {
                    this.setText(SVNUIMessages.AddToSVNPanel_IgnoreByExtension_Multiple);
                }
                boolean isUpdate = false;
                if (super.updateSelection(selection)) {
                    if (selectedResources.length == 1) {
                        String[] parts = this.getNameParts(selectedResources);
                        if (parts.length != 0) {
                            isUpdate = true;
                        }
                    } else {
                        isUpdate = true;
                    }
                }
                return isUpdate;
            }

            protected String[] getNameParts(IResource[] selectedResources) {
                String name = selectedResources[0].getName();
                String[] parts = name.split("\\.");
                return parts;
            }
        }

        protected static class AddToIgnoreByNameAction
        extends AbstractSynchronizeModelAction {
            public AddToIgnoreByNameAction(String text, ISynchronizePageConfiguration configuration) {
                super(text, configuration);
            }

            protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
                IResource[] selectedResources = this.getAllSelectedResources();
                CompositeOperation op = new CompositeOperation("Operation_AddToSVNIgnore", SVNMessages.class);
                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                return op;
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                IResource[] selectedResources = this.getAllSelectedResources();
                if (selectedResources.length == 1) {
                    this.setText(BaseMessages.format((String)SVNUIMessages.AddToSVNPanel_Ignore_Single, (Object)selectedResources[0].getName()));
                } else if (selectedResources.length > 1) {
                    this.setText(SVNUIMessages.AddToSVNPanel_IgnoreByNames_Multiple);
                }
                return super.updateSelection(selection);
            }
        }
    }
}

