/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;

public class PathRevisionConnectionsValidator {
    protected RepositoryCache repositoryCache;

    public PathRevisionConnectionsValidator(RepositoryCache repositoryCache) {
        this.repositoryCache = repositoryCache;
    }

    public void validate(PathRevision node) {
        if (node.getNext() != null && node.getPathIndex() != ((PathRevision)node.getNext()).getPathIndex()) {
            this.reportProblem(node, "Its path and next node path are not equal. Next node: " + ((PathRevision)node.getNext()).toString(this.repositoryCache));
        }
        if (node.getPrevious() != null && node.getPathIndex() != ((PathRevision)node.getPrevious()).getPathIndex()) {
            this.reportProblem(node, "Its path and previous node path are not equal. Previous node: " + ((PathRevision)node.getPrevious()).toString(this.repositoryCache));
        }
        if (node.getCopiedFrom() != null && node.getPrevious() != null) {
            this.reportProblem(node, "It contains previous and copied from nodes. Previous node: " + ((PathRevision)node.getPrevious()).toString(this.repositoryCache) + ", " + "copied from node: " + ((PathRevision)node.getCopiedFrom()).toString(this.repositoryCache));
        }
        PathRevision[] copiedToNodes = node.getCopiedTo();
        PathRevision renameNode = null;
        PathRevision[] pathRevisionArray = copiedToNodes;
        int n = copiedToNodes.length;
        int n2 = 0;
        while (n2 < n) {
            PathRevision copiedToNode = pathRevisionArray[n2];
            if (copiedToNode.action == PathRevision.RevisionNodeAction.RENAME) {
                if (node.getNext() != null) {
                    this.reportProblem(node, "It contains next and rename nodes. Next node: " + ((PathRevision)node.getNext()).toString(this.repositoryCache) + ", " + "rename node: " + copiedToNode.toString(this.repositoryCache));
                }
                if (renameNode != null) {
                    this.reportProblem(node, "It contains several rename nodes. Rename node1: " + renameNode.toString(this.repositoryCache) + ", " + "rename node2: " + copiedToNode.toString(this.repositoryCache));
                }
                renameNode = copiedToNode;
            }
            ++n2;
        }
    }

    protected void reportProblem(PathRevision node, String string) {
        String message = "Not valid node: " + node.toString(this.repositoryCache) + ". ";
        throw new RuntimeException(String.valueOf(message) + string);
    }
}

