/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseRevisionGraphAction
extends SelectionAction {
    protected static final AbstractRevisionEditPartFilter NOT_DELETED_ACTION_FILTER = new AbstractRevisionEditPartFilter(){

        public boolean accept(RevisionEditPart editPart) {
            RevisionNode node = editPart.getCastedModel();
            return node.getAction() != PathRevision.RevisionNodeAction.DELETE;
        }
    };
    protected static final AbstractRevisionEditPartFilter EXIST_IN_PREVIOUS_FILTER = new AbstractRevisionEditPartFilter(){

        public boolean accept(RevisionEditPart editPart) {
            RevisionNode node = editPart.getCastedModel();
            PathRevision.RevisionNodeAction action = node.getAction();
            return action == PathRevision.RevisionNodeAction.MODIFY || action == PathRevision.RevisionNodeAction.NONE;
        }
    };
    protected static final AbstractRevisionEditPartFilter NULL_FILTER = new AbstractRevisionEditPartFilter(){

        public boolean accept(RevisionEditPart editPart) {
            return true;
        }
    };

    public BaseRevisionGraphAction(IWorkbenchPart part) {
        super(part);
    }

    protected void runOperation(IActionOperation op) {
        if (op == null) {
            return;
        }
        UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this.getWorkbenchPart(), (IActionOperation)op);
    }

    protected boolean isEnable(AbstractRevisionEditPartFilter filter, int editPartsCount) {
        return this.getSelectedEditParts().length == editPartsCount && this.getSelectedEditParts(filter).length == editPartsCount;
    }

    protected RevisionEditPart[] getSelectedEditParts(AbstractRevisionEditPartFilter filter) {
        ArrayList<RevisionEditPart> res = new ArrayList<RevisionEditPart>();
        List selected = this.getSelectedObjects();
        if (!selected.isEmpty()) {
            for (Object obj : selected) {
                RevisionEditPart editPart;
                if (!(obj instanceof RevisionEditPart) || !filter.accept(editPart = (RevisionEditPart)obj)) continue;
                res.add(editPart);
            }
        }
        return res.toArray(new RevisionEditPart[0]);
    }

    protected RevisionEditPart[] getSelectedEditParts() {
        return this.getSelectedEditParts(NULL_FILTER);
    }

    protected RevisionEditPart getSelectedEditPart() {
        Object obj;
        List selected = this.getSelectedObjects();
        if (!selected.isEmpty() && (obj = selected.get(0)) instanceof RevisionEditPart) {
            return (RevisionEditPart)obj;
        }
        return null;
    }

    protected IRepositoryLocation getRepositoryLocation(RevisionEditPart editPart) {
        return editPart.getRevisionRootNode().getRepositoryResource().getRepositoryLocation();
    }

    public static IRepositoryResource[] convertToResources(RevisionEditPart[] editParts) {
        IRepositoryResource[] result = new IRepositoryResource[editParts.length];
        int i = 0;
        while (i < editParts.length) {
            result[i] = BaseRevisionGraphAction.convertToResource(editParts[i]);
            ++i;
        }
        return result;
    }

    public static IRepositoryResource convertToResource(RevisionEditPart editPart) {
        RevisionNode revisionNode = editPart.getCastedModel();
        RevisionRootNode rootNode = editPart.getRevisionRootNode();
        boolean isFolder = !(rootNode.getRepositoryResource() instanceof IRepositoryFile);
        String url = rootNode.getRevisionFullPath(revisionNode);
        IRepositoryResource resource = SVNUtility.asRepositoryResource((String)url, (boolean)isFolder);
        SVNRevision.Number svnRev = SVNRevision.fromNumber((long)revisionNode.getRevision());
        resource.setSelectedRevision((SVNRevision)svnRev);
        resource.setPegRevision((SVNRevision)svnRev);
        return resource;
    }

    protected static abstract class AbstractRevisionEditPartFilter {
        protected AbstractRevisionEditPartFilter() {
        }

        public abstract boolean accept(RevisionEditPart var1);
    }
}

