/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.jface.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.swt.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;

public class CustomTrayDialog
extends TrayDialog {
    protected static final int comboHistoryLength = 10;
    private String contextHelpId = null;
    private IDialogSettings dialogSettings;

    public CustomTrayDialog(Shell shell) {
        this(shell, null);
    }

    public CustomTrayDialog(Shell shell, String contextHelpId) {
        super(shell);
        this.initializeDialogSettings();
        this.setContextHelpId(contextHelpId);
    }

    protected void setContextHelpId(String contextHelpId) {
        this.contextHelpId = contextHelpId;
        this.setHelpAvailable(contextHelpId != null);
    }

    protected void initializeDialogSettings() {
        IDialogSettings settings = this.doGetDialogSettingsToInitialize();
        Assert.isNotNull((Object)settings);
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        this.setDialogSettings(section);
    }

    protected IDialogSettings doGetDialogSettingsToInitialize() {
        return UIPlugin.getDefault().getDialogSettings();
    }

    public String getDialogSettingsSectionName() {
        return "CustomTrayDialog";
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.initializeDialogSettings();
        }
        return this.dialogSettings;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected final Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            ScrolledComposite sc = new ScrolledComposite((Composite)control, 512);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            sc.setLayout((Layout)layout);
            sc.setLayoutData((Object)new GridData(1808));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.configureDialogAreaControl((Composite)sc);
            Composite composite = new Composite((Composite)sc, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createDialogAreaContent(composite);
            sc.setContent((Control)composite);
            sc.setMinSize(composite.computeSize(-1, -1));
            control = sc;
        }
        return control;
    }

    protected void createDialogAreaContent(Composite parent) {
        Assert.isNotNull((Object)parent);
    }

    protected void configureDialogAreaControl(Composite composite) {
        Assert.isNotNull((Object)composite);
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List<String> history, String newEntry) {
        Assert.isNotNull((Object)newEntry);
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 10) {
            history.remove(10);
        }
    }

    protected void saveWidgetValues() {
    }

    protected void restoreWidgetValues() {
    }

    protected void okPressed() {
        this.saveWidgetValues();
        super.okPressed();
    }

    protected void dispose() {
        this.dialogSettings = null;
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }
}

