/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.filetransfer;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.launch.ui.tabs.filetransfers.AbstractFileTransferSection;
import org.eclipse.tcf.te.runtime.services.filetransfer.FileTransferItem;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.tcf.launch.core.filetransfer.FileTransferItemValidator;
import org.eclipse.tcf.te.tcf.launch.ui.filetransfer.AddEditFileTransferDialog;
import org.eclipse.ui.forms.IManagedForm;

public class FileTransferSection
extends AbstractFileTransferSection {
    public FileTransferSection(IManagedForm form, Composite parent) {
        super(form, parent);
    }

    protected boolean validateInputList() {
        List list = this.getInputList();
        boolean valid = true;
        for (IFileTransferItem item : list) {
            Map invalid = item.getBooleanProperty("enabled") ? FileTransferItemValidator.validate((IFileTransferItem)item) : null;
            item.setProperty("validation_result.transient", (Object)invalid);
            if (!valid || invalid == null) continue;
            valid = false;
            this.setMessage((String)invalid.get(invalid.keySet().toArray()[0]), 3);
        }
        return valid;
    }

    protected void onButtonAddClick() {
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        List list = this.getInputList();
        FileTransferItem item = new FileTransferItem();
        AddEditFileTransferDialog dialog = new AddEditFileTransferDialog(this.getSection().getShell(), null, (IFileTransferItem)item, this.launchContext);
        if (dialog.open() == 0) {
            item.setProperty("enabled", true);
            list.add(selIndex != -1 ? selIndex : 0, item);
            this.setInputList(list);
            ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)item), true);
        }
    }

    protected void onButtonEditClick() {
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        if (selIndex >= 0) {
            List list = this.getInputList();
            IFileTransferItem item = (IFileTransferItem)list.get(selIndex);
            AddEditFileTransferDialog dialog = new AddEditFileTransferDialog(this.getSection().getShell(), null, item, this.launchContext);
            if (dialog.open() == 0) {
                list.set(selIndex, item);
                this.setInputList(list);
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)item), true);
            }
        }
    }
}

