/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.AbstractSiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.jface.viewers.IToolTipProvider;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public class EditModeDecorationDescriptorProvider
extends AbstractSiriusDecorationDescriptorProvider {
    private static final String NAME = "editModeDecorator";

    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        return true;
    }

    @Override
    public List<DecorationDescriptor> createDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        Image decorationImage = this.getDecorationImage((EditPart)editPart);
        if (decorationImage != null) {
            DecorationDescriptor decoDesc = new DecorationDescriptor();
            decoDesc.setName(NAME);
            decoDesc.setPosition(Position.SOUTH_WEST_LITERAL);
            decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
            decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.HIGH_PRIORITY.getValue());
            decoDesc.setDecorationAsImage(decorationImage);
            decoDesc.setTooltipAsString(this.getToolTip(editPart));
            return Arrays.asList(decoDesc);
        }
        return new ArrayList<DecorationDescriptor>();
    }

    private String getToolTip(IDiagramElementEditPart editPart) {
        IToolTipProvider tooltipProvider;
        EObject representedObject = editPart.resolveTargetSemanticElement();
        if (representedObject != null && (tooltipProvider = (IToolTipProvider)Platform.getAdapterManager().getAdapter((Object)representedObject, IToolTipProvider.class)) != null) {
            return tooltipProvider.getToolTipText((Object)representedObject);
        }
        return null;
    }

    protected boolean isBroken(IDiagramElementEditPart editPart) {
        EObject target = editPart.resolveTargetSemanticElement();
        return this.isBroken(target);
    }

    protected boolean isBroken(EObject eObject) {
        return eObject == null || eObject.eResource() == null;
    }

    @Override
    protected boolean shouldBeDecorated(EditPart editPart) {
        return editPart instanceof IDiagramElementEditPart && super.shouldBeDecorated(editPart);
    }

    protected Image getDecorationImage(EditPart editPart) {
        Image decorationImage = null;
        if (editPart instanceof IDiagramElementEditPart) {
            EObject representedObject;
            IPermissionAuthority auth;
            IDiagramElementEditPart part = (IDiagramElementEditPart)editPart;
            Boolean isBroken = null;
            if (this.isDecorableEditPart(part) && (auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(part.getEditingDomain().getResourceSet())) != null && !(isBroken = Boolean.valueOf(this.isBroken(representedObject = part.resolveTargetSemanticElement()))).booleanValue()) {
                decorationImage = this.getLockStatusDecorationImage(auth.getLockStatus(representedObject));
            }
            if (decorationImage == null && (isBroken != null && isBroken.booleanValue() || isBroken == null && this.isBroken(part))) {
                decorationImage = DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/deletedDiagElemDecorator.gif"));
            }
        }
        return decorationImage;
    }

    protected Image getLockStatusDecorationImage(LockStatus lockStatus) {
        if (LockStatus.LOCKED_BY_OTHER.equals((Object)lockStatus)) {
            return DiagramUIPlugin.getPlugin().getImage(SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)"icons/full/decorator/permission_denied.gif"));
        }
        return null;
    }
}

