/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout.observation;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.ext.base.Option;

public class SequenceObservationLayout
extends AbstractSequenceLayout<ObservationPoint, Point> {
    private Map<EventEnd, ObservationPoint> endToObservationPoint = Maps.newHashMap();

    public SequenceObservationLayout(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram);
    }

    @Override
    protected void init(boolean pack) {
        for (ObservationPoint point : this.sequenceDiagram.getAllObservationPoints()) {
            Option<EventEnd> observedEventEnd = point.getObservedEventEnd();
            if (!observedEventEnd.some()) continue;
            this.endToObservationPoint.put((EventEnd)observedEventEnd.get(), point);
        }
    }

    @Override
    protected Map<? extends ObservationPoint, Point> computeLayout(boolean pack) {
        HashMap computedLayout = Maps.newHashMap();
        for (ISequenceEvent iSequenceEvent : this.sequenceDiagram.getAllDelimitedSequenceEvents()) {
            Rectangle bounds = iSequenceEvent.getProperLogicalBounds();
            List<EventEnd> foundEnds = this.sequenceDiagram.findEnds(iSequenceEvent);
            for (EventEnd eventEnd : foundEnds) {
                SingleEventEnd see;
                Point refPoint = null;
                ObservationPoint observationPoint = this.endToObservationPoint.get(eventEnd);
                if (observationPoint == null) continue;
                if (eventEnd instanceof SingleEventEnd) {
                    Message msg;
                    see = (SingleEventEnd)eventEnd;
                    refPoint = iSequenceEvent instanceof Message ? ((msg = (Message)iSequenceEvent).isReflective() ? (see.isStart() ? bounds.getTopLeft().getCopy() : bounds.getBottomRight().getCopy()) : (see.isStart() ? bounds.getTopLeft().getCopy() : bounds.getBottomRight().getCopy())) : (iSequenceEvent instanceof AbstractFrame || iSequenceEvent instanceof Operand ? (see.isStart() ? bounds.getTopLeft().getCopy() : bounds.getBottomLeft().getCopy()) : (see.isStart() ? bounds.getTop().getCopy() : bounds.getBottom().getCopy()));
                } else if (eventEnd instanceof CompoundEventEnd) {
                    if (iSequenceEvent instanceof State && iSequenceEvent.isLogicallyInstantaneous()) {
                        refPoint = bounds.getLeft().getCopy();
                    } else if (iSequenceEvent instanceof Execution) {
                        see = EventEndHelper.getSingleEventEnd(eventEnd, (EObject)iSequenceEvent.getSemanticTargetElement().get());
                        refPoint = see.isStart() ? bounds.getTop().getCopy() : bounds.getBottom().getCopy();
                    } else if (iSequenceEvent instanceof Operand) {
                        see = EventEndHelper.getSingleEventEnd(eventEnd, (EObject)iSequenceEvent.getSemanticTargetElement().get());
                        Point point = refPoint = see.isStart() ? bounds.getTopLeft().getCopy() : bounds.getBottomLeft().getCopy();
                    }
                }
                if (refPoint == null) continue;
                computedLayout.put(observationPoint, refPoint);
            }
        }
        return computedLayout;
    }

    @Override
    protected boolean applyComputedLayout(Map<? extends ObservationPoint, Point> finalLocations, boolean pack) {
        boolean applied = false;
        for (ObservationPoint point : this.sequenceDiagram.getAllObservationPoints()) {
            Point computedCenter = finalLocations.get(point);
            if (computedCenter == null) continue;
            Node notationNode = point.getNotationNode();
            Bounds bounds = (Bounds)notationNode.getLayoutConstraint();
            int midWidth = bounds.getWidth() / 2;
            if (bounds.getWidth() == -1) {
                midWidth = new DNodeQuery((DNode)((DNode)point.getNotationNode().getElement())).getDefaultDimension().width / 2;
            }
            int midHeight = bounds.getHeight() / 2;
            if (bounds.getHeight() == -1) {
                midHeight = new DNodeQuery((DNode)((DNode)point.getNotationNode().getElement())).getDefaultDimension().height / 2;
            }
            int x = computedCenter.x - midWidth;
            int y = computedCenter.y - midHeight;
            bounds.setX(x);
            bounds.setY(y);
            applied = true;
        }
        return applied;
    }

    @Override
    protected Point getOldLayoutData(ObservationPoint obsPoint) {
        return obsPoint.getObservedLogicalLocation();
    }

    @Override
    protected void dispose() {
        this.endToObservationPoint.clear();
        super.dispose();
    }
}

