/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.ConnectionEndpointType;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.DiagramConnectionFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionLabelModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionLabelEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.IConfigurationManagerHolder;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramConnectionBendpointEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramConnectionEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramConnectionEndpointEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramConnectionLabelEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramConnectionPresentation;

public class DiagramConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
IConfigurationManagerHolder {
    private List<DiagramConnectionLabelModel> modelChildren;
    private DiagramConfigurationManager configManager;

    public DiagramConnectionEditPart(DiagramConfigurationManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public DiagramConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new DiagramConnectionEndpointEditPolicy(this.getCastedModel().getDiagramModel().getResourceCache()));
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new DiagramConnectionBendpointEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramConnectionLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DiagramConnectionEditPolicy());
    }

    protected IFigure createFigure() {
        DiagramConnectionFigure connection = new DiagramConnectionFigure();
        IDiagramConnectionDef def = this.getCastedModel().getModelPart().getConnectionDef();
        ConnectionEndpointType type1 = ConnectionEndpointType.NONE;
        if (def.getEndpoint1() != null) {
            type1 = (ConnectionEndpointType)def.getEndpoint1().getType().content();
        }
        if (type1.equals((Object)ConnectionEndpointType.ARROW)) {
            connection.setSourceDecoration((RotatableDecoration)new PolygonDecoration());
        }
        ConnectionEndpointType type2 = ConnectionEndpointType.NONE;
        if (def.getEndpoint2() != null) {
            type2 = (ConnectionEndpointType)def.getEndpoint2().getType().content();
        }
        if (type2.equals((Object)ConnectionEndpointType.ARROW)) {
            connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        }
        this.updateStyle(connection);
        return connection;
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().removePropertyChangeListener(this);
        }
    }

    public DiagramConnectionModel getCastedModel() {
        return (DiagramConnectionModel)this.getModel();
    }

    public DiagramConnectionPresentation getPresentation() {
        return this.getCastedModel().getPresentation();
    }

    public void updateStyle(PolylineConnection connection) {
        DiagramResourceCache resourceCache = this.getCastedModel().getDiagramModel().getResourceCache();
        DiagramConnectionPart connectionPart = this.getCastedModel().getModelPart();
        IDiagramConnectionDef def = connectionPart.getConnectionDef();
        connection.setLineStyle(resourceCache.getLinkStyle(def));
        connection.setLineWidth(((Integer)def.getLineWidth().content()).intValue());
        connection.setForegroundColor(resourceCache.getLineColor(connectionPart));
    }

    private void refreshBendpoints() {
        DiagramConnectionPart connectionPart = this.getCastedModel().getModelPart();
        ArrayList<AbsoluteBendpoint> figureConstraint = new ArrayList<AbsoluteBendpoint>();
        for (Point point : connectionPart.getBendpoints()) {
            AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(point.getX(), point.getY());
            figureConstraint.add(bendpoint);
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
    }

    protected List<DiagramConnectionLabelModel> getModelChildren() {
        if (this.modelChildren == null) {
            this.modelChildren = new ArrayList<DiagramConnectionLabelModel>(1);
            if (this.getCastedModel().getModelPart().canEditLabel()) {
                this.modelChildren.add(new DiagramConnectionLabelModel(this.getCastedModel()));
            }
        }
        return this.modelChildren;
    }

    private void updateLabel() {
        for (DiagramConnectionLabelModel child : this.getModelChildren()) {
            child.handleUpdateLabel();
        }
    }

    private void updateLabelMoved() {
        for (DiagramConnectionLabelModel child : this.getModelChildren()) {
            child.handleUpdateLabelMoved();
        }
    }

    private void startEditing() {
        for (DiagramConnectionLabelModel child : this.getModelChildren()) {
            child.handleStartEditing();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("CONNECTION_UPDATES".equals(prop)) {
            this.updateLabel();
        } else if ("CONNECTION_LABEL_MOVED".equals(prop)) {
            this.updateLabelMoved();
        } else if ("CONNECTION_BEND_POINTS".equals(prop)) {
            this.refreshVisuals();
        } else if ("CONNECTION_START_EDITING".equals(prop)) {
            this.startEditing();
        }
    }

    private static final class DiagramConnectionLayoutEditPolicy
    extends LayoutEditPolicy {
        private DiagramConnectionLayoutEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            if (child instanceof DiagramConnectionLabelEditPart) {
                return new DiagramConnectionLabelEditPolicy();
            }
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }

        protected Command getAddCommand(Request request) {
            return super.getAddCommand(request);
        }
    }
}

