/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.tips;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.utils.rcp.Browsers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureContentAssistInformationControl
extends AbstractInformationControl {
    private static final List<SessionProcessorDescriptor> NONE = Collections.emptyList();
    private static final String HTTP = "http:";
    private static final String HTTPS = "https:";
    public static final String X_PREFERENCES = "X-preferences:";
    public static final String X_SESSION_PROCESSOR = "X-sessionProcessor:";
    public static final char SWITCH_ON = '+';
    public static final char SWITCH_OFF = '-';
    private final String info;
    private final CompletionRcpPreferences preferences;
    private final String statusLineText;

    public ConfigureContentAssistInformationControl(Shell parent, String statusLineText, String info, CompletionRcpPreferences preferences) {
        super(parent, statusLineText);
        this.info = Objects.requireNonNull(info);
        this.preferences = preferences;
        this.statusLineText = statusLineText;
        this.create();
    }

    public boolean hasContents() {
        return true;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new ConfigureContentAssistInformationControl(parent, ConfigureContentAssistInformationControl.this.statusLineText, ConfigureContentAssistInformationControl.this.info, ConfigureContentAssistInformationControl.this.preferences);
            }
        };
    }

    protected void createContent(Composite parent) {
        Link link = new Link(parent, 0);
        Dialog.applyDialogFont((Control)link);
        link.setForeground(parent.getForeground());
        link.setBackground(parent.getBackground());
        link.setText(this.info);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureContentAssistInformationControl.this.dispose();
                String url = e.text;
                if (StringUtils.startsWith((CharSequence)url, (CharSequence)ConfigureContentAssistInformationControl.HTTP) || StringUtils.startsWith((CharSequence)url, (CharSequence)ConfigureContentAssistInformationControl.HTTPS)) {
                    Browsers.tryOpenInExternalBrowser((String)url);
                } else if (StringUtils.startsWith((CharSequence)url, (CharSequence)ConfigureContentAssistInformationControl.X_PREFERENCES)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)StringUtils.substringAfter((String)url, (String)ConfigureContentAssistInformationControl.X_PREFERENCES), null, null).open();
                } else if (ConfigureContentAssistInformationControl.this.preferences != null && StringUtils.startsWith((CharSequence)url, (CharSequence)ConfigureContentAssistInformationControl.X_SESSION_PROCESSOR)) {
                    String sessionProcessorIdWithSwitch = StringUtils.substringAfter((String)url, (String)ConfigureContentAssistInformationControl.X_SESSION_PROCESSOR);
                    char processorSwitch = sessionProcessorIdWithSwitch.charAt(0);
                    String sessionProcessorId = StringUtils.substring((String)sessionProcessorIdWithSwitch, (int)1);
                    SessionProcessorDescriptor descriptor = ConfigureContentAssistInformationControl.this.preferences.getSessionProcessorDescriptor(sessionProcessorId);
                    if (descriptor != null) {
                        if (processorSwitch == '+') {
                            ConfigureContentAssistInformationControl.this.preferences.setSessionProcessorEnabled((Collection<SessionProcessorDescriptor>)ImmutableList.of((Object)descriptor), NONE);
                        } else if (processorSwitch == '-') {
                            ConfigureContentAssistInformationControl.this.preferences.setSessionProcessorEnabled(NONE, (Collection<SessionProcessorDescriptor>)ImmutableList.of((Object)descriptor));
                        }
                    }
                }
            }
        });
    }
}

