/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.recommenders.internal.completion.rcp.Constants;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.swt.graphics.Point;

public class ProposalCollectingCompletionRequestor
extends CompletionRequestor {
    private static final Field F_PROPOSALS = (Field)Reflections.getDeclaredField((boolean)true, CompletionProposalCollector.class, (String)"fJavaProposals").orNull();
    private static int lastKnownProposalKind;
    private final Map<IJavaCompletionProposal, CompletionProposal> proposals = new IdentityHashMap<IJavaCompletionProposal, CompletionProposal>();
    private JavaContentAssistInvocationContext jdtuiContext;
    private CompletionProposalCollector collector;
    private InternalCompletionContext compilerContext;

    static {
        int lastKnownProposalKind = 27;
        try {
            Field lastKindField = (Field)Reflections.getDeclaredField((boolean)true, CompletionProposal.class, (String)"LAST_KIND").orNull();
            if (lastKindField != null) {
                lastKnownProposalKind = (Integer)lastKindField.get(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {}
        ProposalCollectingCompletionRequestor.lastKnownProposalKind = lastKnownProposalKind;
    }

    public ProposalCollectingCompletionRequestor(JavaContentAssistInvocationContext ctx) {
        super(false);
        this.jdtuiContext = Objects.requireNonNull(ctx);
        this.initalizeCollector();
    }

    private void initalizeCollector() {
        this.collector = this.shouldFillArgumentNames() ? new FillArgumentNamesCompletionProposalCollector(this.jdtuiContext) : new CompletionProposalCollector(this.jdtuiContext.getCompilationUnit(), true);
        this.configureInterestedProposalTypes();
        this.adjustProposalReplacementLength();
    }

    private void configureInterestedProposalTypes() {
        String[] excludes = PreferenceConstants.getExcludedCompletionProposalCategories();
        if (this.doesJdtProposeTypesOnly(excludes)) {
            this.setIgnoreNonTypes(true);
        } else {
            this.setIgnoreNonTypes(false);
        }
        if (this.doesJdtProposeNonTypesOnly(excludes)) {
            this.setIgnoreTypes(true);
        } else {
            this.setIgnoreTypes(false);
        }
        this.setIgnoredSafely(19, false);
        this.setIgnoredSafely(14, false);
        this.setIgnoredSafely(20, false);
        this.setIgnoredSafely(15, false);
        this.setIgnoredSafely(18, false);
        this.setIgnoredSafely(16, false);
        this.setIgnoredSafely(17, false);
        this.setAllowsRequiredProposalsSafely(2, 9, true);
        this.setAllowsRequiredProposalsSafely(2, 23, true);
        this.setAllowsRequiredProposalsSafely(2, 21, true);
        this.setAllowsRequiredProposalsSafely(6, 9, true);
        this.setAllowsRequiredProposalsSafely(6, 23, true);
        this.setAllowsRequiredProposalsSafely(6, 22, true);
        this.setAllowsRequiredProposalsSafely(26, 9, true);
        this.setAllowsRequiredProposalsSafely(27, 9, true);
        this.setAllowsRequiredProposalsSafely(1, 9, true);
        this.setAllowsRequiredProposalsSafely(9, 9, true);
        this.collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        this.collector.setRequireExtendedContext(true);
    }

    private boolean doesJdtProposeTypesOnly(String[] excludes) {
        return !ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaTypeProposalCategory") && ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaAllProposalCategory") && ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaNoTypeProposalCategory");
    }

    private boolean doesJdtProposeNonTypesOnly(String[] excludes) {
        return !ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaNoTypeProposalCategory") && ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaAllProposalCategory") && ArrayUtils.contains((Object[])excludes, (Object)"org.eclipse.jdt.ui.javaTypeProposalCategory");
    }

    private void setIgnoreNonTypes(boolean ignored) {
        this.setIgnoredSafely(13, ignored);
        this.setIgnoredSafely(1, ignored);
        this.setIgnoredSafely(27, ignored);
        this.setIgnoredSafely(2, ignored);
        this.setIgnoredSafely(25, ignored);
        this.setIgnoredSafely(3, ignored);
        this.setIgnoredSafely(4, ignored);
        this.setIgnoredSafely(5, ignored);
        this.setIgnoredSafely(7, ignored);
        this.setIgnoredSafely(12, ignored);
        this.setIgnoredSafely(6, ignored);
        this.setIgnoredSafely(26, ignored);
        this.setIgnoredSafely(24, ignored);
        this.setIgnoredSafely(8, ignored);
        this.setIgnoredSafely(11, ignored);
        this.setIgnoredSafely(10, ignored);
        this.setIgnoredSafely(28, ignored);
        this.setIgnoredSafely(29, ignored);
    }

    private void setIgnoreTypes(boolean ignored) {
        this.setIgnoredSafely(9, ignored);
    }

    public boolean isIgnored(int completionProposalKind) {
        return this.collector.isIgnored(completionProposalKind);
    }

    public void setIgnored(int completionProposalKind, boolean ignore) {
        this.collector.setIgnored(completionProposalKind, ignore);
    }

    private void setIgnoredSafely(int completionProposalKind, boolean ignore) {
        if (completionProposalKind > lastKnownProposalKind) {
            return;
        }
        this.collector.setIgnored(completionProposalKind, ignore);
    }

    public boolean isAllowingRequiredProposals(int proposalKind, int requiredProposalKind) {
        return this.collector.isAllowingRequiredProposals(proposalKind, requiredProposalKind);
    }

    public void setAllowsRequiredProposals(int proposalKind, int requiredProposalKind, boolean allow) {
        this.collector.setAllowsRequiredProposals(proposalKind, requiredProposalKind, allow);
    }

    private void setAllowsRequiredProposalsSafely(int proposalKind, int requiredProposalKind, boolean allow) {
        if (proposalKind > lastKnownProposalKind) {
            return;
        }
        if (requiredProposalKind > lastKnownProposalKind) {
            return;
        }
        this.collector.setAllowsRequiredProposals(proposalKind, requiredProposalKind, allow);
    }

    public boolean isExtendedContextRequired() {
        return this.collector.isExtendedContextRequired();
    }

    public String[] getFavoriteReferences() {
        return this.collector.getFavoriteReferences();
    }

    private void adjustProposalReplacementLength() {
        ITextViewer viewer = this.jdtuiContext.getViewer();
        Point selection = viewer.getSelectedRange();
        if (selection.y > 0) {
            this.collector.setReplacementLength(selection.y);
        }
    }

    @VisibleForTesting
    protected boolean shouldFillArgumentNames() {
        try {
            return PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void acceptContext(CompletionContext context) {
        this.compilerContext = (InternalCompletionContext)Checks.cast((Object)context);
        this.collector.acceptContext(context);
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return CharOperation.NO_STRINGS;
    }

    public void accept(CompletionProposal compilerProposal) {
        IJavaCompletionProposal[] iJavaCompletionProposalArray = this.createJdtProposals(compilerProposal);
        int n = iJavaCompletionProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal uiProposal = iJavaCompletionProposalArray[n2];
            this.proposals.put(uiProposal, compilerProposal);
            ++n2;
        }
    }

    private IJavaCompletionProposal[] createJdtProposals(CompletionProposal proposal) {
        if (F_PROPOSALS != null) {
            try {
                List list = (List)F_PROPOSALS.get(this.collector);
                int oldSize = list.size();
                this.collector.accept(proposal);
                int newSize = list.size();
                List res = list.subList(oldSize, newSize);
                return (IJavaCompletionProposal[])Iterables.toArray(res, IJavaCompletionProposal.class);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
            }
        }
        int oldSize = this.collector.getJavaCompletionProposals().length;
        this.collector.accept(proposal);
        Object[] jdtProposals = this.collector.getJavaCompletionProposals();
        return (IJavaCompletionProposal[])ArrayUtils.subarray((Object[])jdtProposals, (int)oldSize, (int)jdtProposals.length);
    }

    public void setReplacementLength(int y) {
        this.collector.setReplacementLength(y);
    }

    public InternalCompletionContext getCoreContext() {
        return this.compilerContext;
    }

    public Map<IJavaCompletionProposal, CompletionProposal> getProposals() {
        return this.proposals;
    }

    public void completionFailure(IProblem problem) {
        if (Constants.DEBUG) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_COMPLETION_FAILURE_DURING_DEBUG_MODE, (Object[])new Object[]{problem.toString()});
        }
    }
}

